/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.dao.AbstractRecordStatoHandler;
import biz.elabor.prebilling.dao.FlussoResellerMultiUpdateHandler;
import biz.elabor.prebilling.services.reseller.FlussoReseller;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.exceptions.UnrecoverableException;

class RecordResellerUpdateHandler
extends AbstractRecordStatoHandler {
    private final List<FlussoReseller> flussi;
    private final String tabella;

    public RecordResellerUpdateHandler(List<FlussoReseller> flussi, String tabella, Connection connection) {
        super(connection);
        this.flussi = flussi;
        this.tabella = tabella;
    }

    @Override
    public void executeMultiUpdate() throws SQLException, UnrecoverableException {
        FlussoResellerMultiUpdateHandler handler = new FlussoResellerMultiUpdateHandler(this.tabella);
        Condition<FlussoReseller> condition = new Condition<FlussoReseller>(){

            @Override
            public boolean check(FlussoReseller item) {
                String azienda = item.getCodiceAzienda();
                return azienda != null && !azienda.isEmpty();
            }
        };
        Filter<FlussoReseller> filter = new Filter<FlussoReseller>(condition);
        Iterable<FlussoReseller> filtered = filter.iterable(this.flussi);
        this.executeMultiUpdate(filtered, null, handler);
    }
}

