/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;

public class Multipunto {
    private final String raggruppamento;
    private final List<MultipuntoEntry> entries;
    private final List<MultipuntoOption> options;

    public Multipunto(String raggruppamento, List<MultipuntoEntry> entries, List<MultipuntoOption> options) {
        this.raggruppamento = raggruppamento;
        this.entries = entries;
        this.options = options;
    }

    public String getRaggruppamento() {
        return this.raggruppamento;
    }

    public List<MultipuntoEntry> getEntries() {
        return this.entries;
    }

    public List<MultipuntoOption> getOptions(int anno, Month mese) {
        KeyExtractor<MultipuntoOption, MultipuntoOption> extractor = option -> {
            Date inizioMese = CalendarTools.getDate(anno, mese, 1);
            Date fineMese = CalendarTools.getEndDate(anno, mese);
            Date dataValidita = option.getDataValidita();
            Date dataScadenza = option.getDataScadenza();
            return dataValidita.after(fineMese) || dataScadenza.before(inizioMese) ? null : option;
        };
        return StructuresHelper.buildList(this.options, extractor);
    }
}

