/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.ResultRecord;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.AbstractMultiUpdateHandler;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class MnoConsolidamentoMultiUpdateHandler
extends AbstractMultiUpdateHandler<ResultRecord<MisuraNonoraria, PrebillingError>> {
    public MnoConsolidamentoMultiUpdateHandler() {
        super(Funzionalita.CONSOLIDAMENTO, "UPDATE misure_pod_non_orari SET :stato=?, :cod_errore=?, :desc_errore=?, cdaziend=?, potenza_max=? WHERE id=?");
    }

    @Override
    public boolean prepare(PreparedStatement ps, ResultRecord<MisuraNonoraria, PrebillingError> result, StatoMisure stato, String id) throws SQLException {
        MisuraNonoraria misura = result.getRecord();
        PrebillingError errore = result.getErrore();
        ps.setInt(1, stato.getCodice());
        ps.setInt(2, errore.getCodice());
        ps.setString(3, result.getMessaggio());
        ps.setString(4, misura.getCdaziend());
        Number potMax = misura.getPotMax();
        if (potMax == null) {
            ps.setNull(5, 8);
        } else {
            ps.setDouble(5, potMax.doubleValue());
        }
        ps.setString(6, id);
        return true;
    }
}

