/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraNonoraria;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class LettureDeleteHandler
implements TableMultiUpdateHandler<MisuraNonoraria> {
    LettureDeleteHandler() {
    }

    @Override
    public String getQuery() {
        return "delete from letture where pod=? AND data = ? AND tipo= ?";
    }

    @Override
    public boolean prepare(PreparedStatement ps, MisuraNonoraria item, StatoMisure stato, String id) throws SQLException {
        ps.setString(1, item.getCodicePod());
        ps.setDate(2, new Date(item.getDataMisura().getTime()));
        Misura misura = item.getMisura();
        boolean stimata = misura.isStimata();
        String codiceFlusso = item.getCodiceFlusso();
        boolean calcolata = item.isCalcolata();
        String raccolta = item.getRaccolta();
        String matricolaAtt = item.getMatricolaAtt();
        if (matricolaAtt == null) {
            matricolaAtt = "";
        }
        String tipo = TariffeHelper.getTipoLettura(stimata, codiceFlusso, raccolta, matricolaAtt, calcolata);
        ps.setString(3, tipo);
        return true;
    }
}

