/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.dao.DefaultRRS;
import biz.elabor.prebilling.dao.JdbcMisureDao;
import biz.elabor.prebilling.dao.creator.RecordCreatorHelper;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

public class JdbcStatoPod
extends AbstractBasicStatoPod {
    private String servizio;
    private String pod;
    private String cf;
    private String piva;
    private String pivaDistributore;
    private String pivaReseller;
    private String pivaDispatcher;
    private String codiceDispacciamento;
    private String stato;
    private String flagResidente;
    private Date dataMovimento;
    private int nuprogre;
    private Date dataAttivazione;
    private Date dataCessazione;
    private String cdunipre;
    private String cdFlusso;
    private String tabellaRiferimento;
    private String chiaveTabellaRiferimento;
    private String toponimo;
    private String via;
    private String civico;
    private String comuneCatastale;
    private String cap;
    private boolean flagOrario;
    private String cdtardis;
    private int tensione;
    private String livelloTensione;
    private double potenzaContr;
    private double potenzaDisp;
    private boolean flmisCon;
    private boolean flmisRea;
    private boolean flmisPot;
    private double inmisCon;
    private double inmisRea;
    private double inmisPot;
    private double nuLetA01;
    private double nuLetA02;
    private double nuLetA03;
    private double nuLetR01;
    private double nuLetR02;
    private double nuLetR03;
    private double nuLetP01;
    private double nuLetP02;
    private double nuLetP03;
    private String nuMatrA;
    private String nuMatrR;
    private String nuMatrP;
    private String modContatoreA;
    private String modContatoreR;
    private String modContatoreP;
    private boolean flazzconA;
    private boolean flazzconR;
    private boolean flazzconP;
    private int nuCifreA;
    private int nuCifreR;
    private int nuCifreP;
    private int nnFascia;
    private String statoRic;
    private boolean annullata;
    private String servizioTutela;
    private boolean flMisBio;
    private double inMisBio;
    private final double nuLetBio01;
    private final double nuLetBio02;
    private final double nuLetBio03;
    private String nuMatricBio;
    private String modContatoreBio;
    private boolean flAzzConBio;
    private int nuCifreBio;
    private final String codiceOfferta;
    private final Set<String> id;
    private Date dataPrestazione;

    public JdbcStatoPod(ResultSet rs) throws SQLException {
        super(rs.getString("CP_GESTORE"), rs.getString("CP_UTENTE"), rs.getString("FLAG_RESIDENTE"));
        DecimalFormat doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
        DefaultRRS rrs = new DefaultRRS(rs);
        this.dataPrestazione = RecordCreatorHelper.getDate(rrs, "DATA_PRESTAZIONE", JdbcMisureDao.DATE_FORMAT_DIESIS);
        this.servizio = rs.getString("CDSERVIZ").trim();
        this.pod = rs.getString("POD").trim();
        this.cf = rs.getString("CF").trim();
        this.piva = rs.getString("PIVA").trim();
        this.pivaDistributore = rs.getString("PIVA_DISTR").trim();
        this.pivaReseller = rs.getString("PIVA_RESELLER").trim();
        this.pivaDispatcher = rs.getString("PIVA_DISPATCHER").trim();
        this.codiceDispacciamento = rs.getString("CODICE_DISPACCIAMENTO").trim();
        this.stato = rs.getString("STATO").trim();
        this.flagResidente = rs.getString("FLAG_RESIDENTE").trim();
        this.dataMovimento = RecordCreatorHelper.getDate(rrs, "DATA_MOVIMENTO", JdbcMisureDao.DATE_FORMAT_DIESIS);
        this.nuprogre = rs.getInt("NUPROGRE");
        this.dataAttivazione = RecordCreatorHelper.getDate(rrs, "DATA_ATTIVAZIONE", JdbcMisureDao.DATE_FORMAT_DIESIS);
        this.dataCessazione = RecordCreatorHelper.getDate(rrs, "DATA_CESSAZIONE", JdbcMisureDao.DATE_FORMAT_DIESIS);
        this.cdunipre = rs.getString("CDUNIPRE").trim();
        this.cdFlusso = rs.getString("CDFLUSSO").trim();
        this.tabellaRiferimento = rs.getString("TABELLA_RIFERIMENTO").trim();
        this.chiaveTabellaRiferimento = rs.getString("CHIAVE_TABELLA_RIFERIMENTO").trim();
        this.toponimo = rs.getString("TOPONIMO").trim();
        this.via = rs.getString("VIA").trim();
        this.civico = rs.getString("CIVICO").trim();
        this.comuneCatastale = rs.getString("COMUNE_CATASTALE").trim();
        this.cap = rs.getString("CAP").trim();
        this.flagOrario = RecordCreatorHelper.getBoolean(rrs, "FLAG_ORARIO");
        this.cdtardis = rs.getString("CDTARDIS").trim();
        this.tensione = rs.getInt("TENSIONE");
        this.livelloTensione = rs.getString("LIVELLO_TENSIONE");
        this.potenzaContr = RecordCreatorHelper.getDouble(rrs, "POTENZA_CONTR", doubleFormat);
        this.potenzaDisp = RecordCreatorHelper.getDouble(rrs, "POTENZA_DISP", doubleFormat);
        this.flmisCon = RecordCreatorHelper.getBoolean(rrs, "FLMISCON");
        this.flmisRea = RecordCreatorHelper.getBoolean(rrs, "FLMISREA");
        this.flmisPot = RecordCreatorHelper.getBoolean(rrs, "FLMISPOT");
        this.inmisCon = RecordCreatorHelper.getDouble(rrs, "INMISCON", doubleFormat);
        this.inmisRea = RecordCreatorHelper.getDouble(rrs, "INMISREA", doubleFormat);
        this.inmisPot = RecordCreatorHelper.getDouble(rrs, "INMISPOT", doubleFormat);
        this.nnFascia = rs.getInt("NNFASCIA");
        this.nuLetA01 = RecordCreatorHelper.getDouble(rrs, "NULETA01", doubleFormat);
        this.nuLetA02 = RecordCreatorHelper.getDouble(rrs, "NULETA02", doubleFormat);
        this.nuLetA03 = RecordCreatorHelper.getDouble(rrs, "NULETA03", doubleFormat);
        this.nuLetR01 = RecordCreatorHelper.getDouble(rrs, "NULETR01", doubleFormat);
        this.nuLetR02 = RecordCreatorHelper.getDouble(rrs, "NULETR02", doubleFormat);
        this.nuLetR03 = RecordCreatorHelper.getDouble(rrs, "NULETR03", doubleFormat);
        this.nuLetP01 = RecordCreatorHelper.getDouble(rrs, "NULETP01", doubleFormat);
        this.nuLetP02 = RecordCreatorHelper.getDouble(rrs, "NULETP02", doubleFormat);
        this.nuLetP03 = RecordCreatorHelper.getDouble(rrs, "NULETP03", doubleFormat);
        this.nuMatrA = rs.getString("NUMATRIC_A").trim();
        this.nuMatrR = rs.getString("NUMATRIC_R").trim();
        this.nuMatrP = rs.getString("NUMATRIC_P").trim();
        this.modContatoreA = rs.getString("MOD_CONTATORE_A").trim();
        this.modContatoreR = rs.getString("MOD_CONTATORE_R").trim();
        this.modContatoreP = rs.getString("MOD_CONTATORE_P").trim();
        this.flazzconA = RecordCreatorHelper.getBoolean(rrs, "FLAZZCON_A");
        this.flazzconR = RecordCreatorHelper.getBoolean(rrs, "FLAZZCON_R");
        this.flazzconP = RecordCreatorHelper.getBoolean(rrs, "FLAZZCON_P");
        this.nuCifreA = rs.getInt("NUCIFRE_A");
        this.nuCifreR = rs.getInt("NUCIFRE_R");
        this.nuCifreP = rs.getInt("NUCIFRE_P");
        this.statoRic = rs.getString("STATO_RIC").trim();
        this.annullata = RecordCreatorHelper.getBoolean(rrs, "FLANNRIC");
        this.servizioTutela = rs.getString("SERVIZIO_TUTELA");
        this.flMisBio = RecordCreatorHelper.getBoolean(rrs, "FLMISBIO");
        this.inMisBio = RecordCreatorHelper.getDouble(rrs, "INMISBIO", doubleFormat);
        this.nuLetBio01 = RecordCreatorHelper.getDouble(rrs, "NULETB01", doubleFormat);
        this.nuLetBio02 = RecordCreatorHelper.getDouble(rrs, "NULETB02", doubleFormat);
        this.nuLetBio03 = RecordCreatorHelper.getDouble(rrs, "NULETB03", doubleFormat);
        this.nuMatricBio = RecordCreatorHelper.getString(rrs, "NUMATRIC_B");
        this.modContatoreBio = RecordCreatorHelper.getString(rrs, "MOD_CONTATORE_B");
        this.flAzzConBio = RecordCreatorHelper.getBoolean(rrs, "FLAZZCON_B");
        this.nuCifreBio = rrs.getInt("NUCIFRE_B");
        this.codiceOfferta = rs.getString("CODICE_OFFERTA");
        this.id = new LinkedHashSet<String>();
        this.id.add(this.chiaveTabellaRiferimento);
    }

    @Override
    public Date getDataPrestazione() {
        return this.dataPrestazione;
    }

    public void setDataPrestazione(Date dataPrestazione) {
        this.dataPrestazione = dataPrestazione;
    }

    @Override
    public String getStatoRic() {
        return this.statoRic;
    }

    @Override
    public String getStato() {
        return this.stato;
    }

    @Override
    public Date getDataCessazione() {
        return this.dataCessazione;
    }

    @Override
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    @Override
    public String getServizio() {
        return this.servizio;
    }

    @Override
    public String getPod() {
        return this.pod;
    }

    @Override
    public String getCf() {
        return this.cf;
    }

    @Override
    public String getPiva() {
        return this.piva;
    }

    @Override
    public String getPivaDistributore() {
        return this.pivaDistributore;
    }

    @Override
    public String getPivaReseller() {
        return this.pivaReseller;
    }

    @Override
    public String getPivaDispatcher() {
        return this.pivaDispatcher;
    }

    @Override
    public String getCodiceDispacciamento() {
        return this.codiceDispacciamento;
    }

    @Override
    public String getFlagResidente() {
        return this.flagResidente;
    }

    @Override
    public int getNuprogre() {
        return this.nuprogre;
    }

    @Override
    public Date getDataAttivazione() {
        return this.dataAttivazione;
    }

    @Override
    public String getCdunipre() {
        return this.cdunipre;
    }

    @Override
    public String getCdFlusso() {
        return this.cdFlusso;
    }

    @Override
    public String getTabellaRiferimento() {
        return this.tabellaRiferimento;
    }

    @Override
    public String getChiaveTabellaRiferimento() {
        return this.chiaveTabellaRiferimento;
    }

    @Override
    public String getToponimo() {
        return this.toponimo;
    }

    @Override
    public String getVia() {
        return this.via;
    }

    @Override
    public String getCivico() {
        return this.civico;
    }

    @Override
    public String getComuneCatastale() {
        return this.comuneCatastale;
    }

    @Override
    public String getCap() {
        return this.cap;
    }

    @Override
    public boolean getFlagOrario() {
        return this.flagOrario;
    }

    @Override
    public String getCdtardis() {
        return this.cdtardis;
    }

    @Override
    public int getTensione() {
        return this.tensione;
    }

    @Override
    public String getLivelloTensione() {
        return this.livelloTensione;
    }

    @Override
    public double getPotenzaContr() {
        return this.potenzaContr;
    }

    @Override
    public double getPotenzaDisp() {
        return this.potenzaDisp;
    }

    @Override
    public boolean getFlmisCon() {
        return this.flmisCon;
    }

    @Override
    public boolean getFlmisRea() {
        return this.flmisRea;
    }

    @Override
    public boolean getFlmisPot() {
        return this.flmisPot;
    }

    @Override
    public double getNuLetA01() {
        return this.nuLetA01;
    }

    @Override
    public double getNuLetA02() {
        return this.nuLetA02;
    }

    @Override
    public double getNuLetA03() {
        return this.nuLetA03;
    }

    @Override
    public double getNuLetR01() {
        return this.nuLetR01;
    }

    @Override
    public double getNuLetR02() {
        return this.nuLetR02;
    }

    @Override
    public double getNuLetR03() {
        return this.nuLetR03;
    }

    @Override
    public double getNuLetP01() {
        return this.nuLetP01;
    }

    @Override
    public double getNuLetP02() {
        return this.nuLetP02;
    }

    @Override
    public double getNuLetP03() {
        return this.nuLetP03;
    }

    @Override
    public double getInmisCon() {
        return this.inmisCon;
    }

    @Override
    public double getInmisRea() {
        return this.inmisRea;
    }

    @Override
    public double getInmisPot() {
        return this.inmisPot;
    }

    @Override
    public String getNuMatrA() {
        return this.nuMatrA;
    }

    @Override
    public String getNuMatrR() {
        return this.nuMatrR;
    }

    @Override
    public String getNuMatrP() {
        return this.nuMatrP;
    }

    @Override
    public String getModContatoreA() {
        return this.modContatoreA;
    }

    @Override
    public String getModContatoreR() {
        return this.modContatoreR;
    }

    @Override
    public String getModContatoreP() {
        return this.modContatoreP;
    }

    @Override
    public boolean isFlazzconA() {
        return this.flazzconA;
    }

    @Override
    public boolean isFlazzconR() {
        return this.flazzconR;
    }

    @Override
    public boolean isFlazzconP() {
        return this.flazzconP;
    }

    @Override
    public int getNuCifreA() {
        return this.nuCifreA;
    }

    @Override
    public int getNuCifreR() {
        return this.nuCifreR;
    }

    @Override
    public int getNuCifreP() {
        return this.nuCifreP;
    }

    @Override
    public int getNnFascia() {
        return this.nnFascia;
    }

    @Override
    public boolean isPraticaAnnullata() {
        return this.annullata;
    }

    @Override
    public String getServizioTutela() {
        return this.servizioTutela;
    }

    @Override
    public boolean isFlMisBio() {
        return this.flMisBio;
    }

    @Override
    public double getInMisBio() {
        return this.inMisBio;
    }

    @Override
    public double getNuLetBio01() {
        return this.nuLetBio01;
    }

    @Override
    public double getNuLetBio02() {
        return this.nuLetBio02;
    }

    @Override
    public double getNuLetBio03() {
        return this.nuLetBio03;
    }

    @Override
    public String getNuMatricBio() {
        return this.nuMatricBio;
    }

    @Override
    public String getModContatoreBio() {
        return this.modContatoreBio;
    }

    @Override
    public boolean isFlAzzConBio() {
        return this.flAzzConBio;
    }

    @Override
    public int getNuCifreBio() {
        return this.nuCifreBio;
    }

    @Override
    public String getCodiceOfferta() {
        return this.codiceOfferta;
    }

    @Override
    public Set<String> getId() {
        return this.id;
    }

    public void setNuCifreA(int nuCifre) {
        this.nuCifreA = nuCifre;
    }

    public void setNuCifreR(int nuCifre) {
        this.nuCifreR = nuCifre;
    }

    public void setNuCifreP(int nuCifre) {
        this.nuCifreP = nuCifre;
    }

    public void setNuCifreBio(int nuCifre) {
        this.nuCifreBio = nuCifre;
    }

    public void setModContatoreA(String modello) {
        this.modContatoreA = modello;
    }

    public void setModContatoreR(String modello) {
        this.modContatoreR = modello;
    }

    public void setModContatoreP(String modello) {
        this.modContatoreP = modello;
    }

    public void setModContatoreBio(String modello) {
        this.modContatoreBio = modello;
    }

    public void setFlMisCon(boolean flag) {
        this.flmisCon = flag;
    }

    public void setFlMisRea(boolean flag) {
        this.flmisRea = flag;
    }

    public void setFlMisPot(boolean flag) {
        this.flmisPot = flag;
    }

    public void setFlMisBio(boolean flag) {
        this.flMisBio = flag;
    }

    public void setInMisCon(double inmis) {
        this.inmisCon = inmis;
    }

    public void setInMisRea(double inmis) {
        this.inmisRea = inmis;
    }

    public void setInMisPot(double inmis) {
        this.inmisPot = inmis;
    }

    public void setInMisBio(double inmis) {
        this.inMisBio = inmis;
    }

    public void setNuMatrA(String nuMatr) {
        this.nuMatrA = nuMatr;
    }

    public void setNuMatrR(String nuMatr) {
        this.nuMatrR = nuMatr;
    }

    public void setNuMatrP(String nuMatr) {
        this.nuMatrP = nuMatr;
    }

    public void setNuMatrBio(String nuMatr) {
        this.nuMatricBio = nuMatr;
    }

    public void setFlAzzConA(boolean flazzcon) {
        this.flazzconA = flazzcon;
    }

    public void setFlAzzConR(boolean flazzcon) {
        this.flazzconR = flazzcon;
    }

    public void setFlAzzConP(boolean flazzcon) {
        this.flazzconP = flazzcon;
    }

    public void setFlAzzConBio(boolean flazzcon) {
        this.flAzzConBio = flazzcon;
    }
}

