/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.dao.TestJdbcMisureDao;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.GetRnoStrategy;
import biz.elabor.prebilling.services.switched.GetSnmStrategy;
import biz.elabor.prebilling.services.volture.GetVnoStrategy;
import biz.elabor.prebilling.services.xml.d479.GetSnm2GEXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPdoXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetPnoXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSmisXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSnfXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSnmXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetSofXmlStrategy;
import biz.elabor.prebilling.services.xml.periodo.GetVnoXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRfoXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRnoXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRnvXmlStrategy;
import biz.elabor.prebilling.services.xml.rettifiche.GetRsnXmlStrategy;
import biz.elabor.prebilling.web.xml.filtri.FiltriXmlDefault;
import java.io.IOException;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;

public class JdbcMisureDaoTest
extends TestCase {
    public void testPdo2GR() throws IOException {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao misureDao = new TestJdbcMisureDao(configuration);
        try {
            TestServiceStatus status = new TestServiceStatus(configuration);
            DefaultPodMap podMap = new DefaultPodMap();
            status.setAllPods(podMap);
            misureDao.getPdo2GRFinoMese(2000, Month.JULY, "piper", StrategyHelper.STATI);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT mpo.*, mpoa.*, mpor.*, mpop.*, mpoa.data AS data_att FROM misure_pod_orari mpo, misure_pod_orari_ea mpoa, misure_pod_orari_er mpor, misure_pod_orari_pot mpop WHERE \tpod_id='piper' AND \tmpoa.misure_pod_orari_id=mpo.id AND \tmpor.misure_pod_orari_id=mpo.id AND \tmpop.misure_pod_orari_id=mpo.id AND \tmpoa.data=mpor.data AND \tmpoa.data=mpop.data AND \t(mpo.anno<'2000' OR (mpo.anno='2000' AND mpo.mese<='7')) AND \t(mpo.cod_flusso = 'PDO2G' AND mpo.regime = 'R') AND \tstato IN ('4','5') ORDER BY mpo.pod_id, mpoa.data", exc.getMessage());
        }
    }

    public void testFlExport() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetPdoXmlStrategy strategy = new GetPdoXmlStrategy("azienda", filtri, dao, null);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT mpo.*, mpoa.*, mpor.*, mpoa.data AS data_att FROM misure_pod_orari mpo, misure_pod_orari_ea mpoa, misure_pod_orari_er mpor WHERE \tcdaziend='azienda' AND \tflexport='1' AND \tto_char(mpoa.data,'yyyymmdd') <= '99991231' AND to_char(mpoa.data,'yyyymmdd') >= '19700101' AND \traccolta in (:raccolte:) AND \tmpor.misure_pod_orari_id=mpo.id AND \tmpoa.misure_pod_orari_id=mpo.id AND \tmpoa.data=mpor.data AND \tmpo.cod_flusso in ('PDO') AND \tstato IN ('4','5','6','7','8') ORDER BY mpo.pod_id, mpoa.data", exc.getMessage());
        }
    }

    public void testGetPnoXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetPnoXmlStrategy strategy = new GetPnoXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM pno WHERE flexport='1' AND cdaziend='azienda' AND to_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101' AND raccolta='P' ORDER BY pod_id, data_misura;", exc.getMessage());
        }
    }

    public void testGetRfoXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetRfoXmlStrategy strategy = new GetRfoXmlStrategy("azienda", filtri, dao, null);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM pdo WHERE flexport='1' AND cdaziend='azienda' AND to_char(mpoa.data,'yyyymmdd') <= '99991231' AND to_char(mpoa.data,'yyyymmdd') >= '19700101' AND ORDER BY pod_id, data_att;", exc.getMessage());
        }
    }

    public void testGetRnoXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetRnoXmlStrategy strategy = new GetRnoXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM misure_pod_non_orari WHERE \tcdaziend='azienda' AND \tflexport='1' AND \tto_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101' AND \tcod_flusso='RNO' AND \tstato IN ('4','5','6','7','8') ORDER BY pod_id, data_misura;", exc.getMessage());
        }
    }

    public void testGetRnoNoAzienda() throws IOException {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        Reseller reseller = new Reseller("*", null, null, false, false);
        GetRnoStrategy strategy = new GetRnoStrategy(reseller, "", dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("select a.*, cdanagra, flmiscon, flmisrea, flmispot, \t(select nuparame from prebilling.tpar030 where cdparame='CCALLGRU') as ccallgru from misure_pod_non_orari a, prebilling.tute000 b, prebilling.tprs000 c where \t \t \ttrim(substr(pod_id,1,14)) = trim(substr(cdprerif,1,14)) and \tb.cdpresa=c.cdpresa and \ta.cod_flusso='RNO' and \tstato IN ('4','5') and \tdata_misura >= TO_DATE('1949/12/31', 'YYYY/MM/DD') + b.dtinifor and \t(b.dtsospen=0 or  data_misura <= TO_DATE('1949/12/31', 'YYYY/MM/DD') + b.dtsospen) order by pod_id, data_misura", exc.getMessage());
        }
    }

    public void testGetRnoAzienda() throws IOException {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        Reseller reseller = new Reseller("azienda", null, null, false, false);
        GetRnoStrategy strategy = new GetRnoStrategy(reseller, "", dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("select a.*, cdanagra, flmiscon, flmisrea, flmispot, \t(select nuparame from prebilling.tpar030 where cdparame='CCALLGRU') as ccallgru from misure_pod_non_orari a, prebilling.tute000 b, prebilling.tprs000 c where \tcdanagra='azienda' AND \t \ttrim(substr(pod_id,1,14)) = trim(substr(cdprerif,1,14)) and \tb.cdpresa=c.cdpresa and \ta.cod_flusso='RNO' and \tstato IN ('4','5') and \tdata_misura >= TO_DATE('1949/12/31', 'YYYY/MM/DD') + b.dtinifor and \t(b.dtsospen=0 or  data_misura <= TO_DATE('1949/12/31', 'YYYY/MM/DD') + b.dtsospen) order by pod_id, data_misura", exc.getMessage());
        }
    }

    public void testGetRnvXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetRnvXmlStrategy strategy = new GetRnvXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM pno WHERE flexport='1' AND cdaziend='azienda' AND to_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101' AND raccolta='P' ORDER BY pod_id, data_misura;", exc.getMessage());
        }
    }

    public void testGetRsnXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetRsnXmlStrategy strategy = new GetRsnXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM pno WHERE flexport='1' AND cdaziend='azienda' AND to_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101' AND raccolta='P' ORDER BY pod_id, data_misura;", exc.getMessage());
        }
    }

    public void testGetSmisXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetSmisXmlStrategy strategy = new GetSmisXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM smis WHERE flexport='1' AND cdaziend='azienda' AND ((to_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101') OR (to_char(data_misura,'yyyymmdd') = '100000101' AND raccolta='M')) AND ORDER BY pod_id, data_misura;", exc.getMessage());
        }
    }

    public void testGetSnfXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetSnfXmlStrategy strategy = new GetSnfXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM snf WHERE flexport='1' AND cdaziend='azienda' AND to_char(data_inizio,'yyyymmdd') <= '99991231' AND to_char(data_inizio,'yyyymmdd') >= '19700101' AND ORDER BY pod_id;", exc.getMessage());
        }
    }

    public void testGetSnm2GEXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetSnm2GEXmlStrategy strategy = new GetSnm2GEXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM misure_pod_non_orari_ea WHERE flexport='1' AND cdaziend='azienda' AND;", exc.getMessage());
        }
    }

    public void testGetSnm() throws IOException {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        GetSnmStrategy strategy = new GetSnmStrategy("", dao, null, StrategyHelper.STATI);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM misure_pod_non_orari WHERE \t \t \t \t \traccolta in ('P','T','V','S') AND \tcod_flusso in ('SNM','SNM2G') AND \tstato IN ('4','5') ORDER by pod_id", exc.getMessage());
        }
    }

    public void testGetSnmXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetSnmXmlStrategy strategy = new GetSnmXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM misure_pod_non_orari WHERE \tcdaziend='azienda' AND \tflexport='1' AND \tto_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101' AND \t \traccolta in ('P','T','V','S') AND \tcod_flusso in ('SNM') AND \tstato IN ('4','5','6','7','8') ORDER by pod_id", exc.getMessage());
        }
    }

    public void testGetSofXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetSofXmlStrategy strategy = new GetSofXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM sof WHERE flexport='1' AND cdaziend='azienda' AND to_char(data_inizio,'yyyymmdd') <= '99991231' AND to_char(data_inizio,'yyyymmdd') >= '19700101' AND ORDER BY pod_id;", exc.getMessage());
        }
    }

    public void testGetVno() throws IOException {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        GetVnoStrategy strategy = new GetVnoStrategy("", dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM misure_pod_non_orari WHERE \t \t \t \t \traccolta in ('P','T','V','S') AND \tcod_flusso='VNO' AND \tstato IN ('4','5') ORDER by pod_id", exc.getMessage());
        }
    }

    public void testGetVnoXml() throws IOException, InvalidParameterValue {
        TestConfiguration configuration = new TestConfiguration();
        TestJdbcMisureDao dao = new TestJdbcMisureDao(configuration);
        FiltriXmlDefault filtri = new FiltriXmlDefault(null, null, null, "1", null, null, "");
        GetVnoXmlStrategy strategy = new GetVnoXmlStrategy("azienda", filtri, dao);
        try {
            strategy.execute(null);
            JdbcMisureDaoTest.fail();
        }
        catch (DataAccessException exc) {
            JdbcMisureDaoTest.assertEquals("SELECT * FROM misure_pod_non_orari WHERE \tcdaziend='azienda' AND \tflexport='1' AND \tto_char(data_misura,'yyyymmdd') <= '99991231' AND to_char(data_misura,'yyyymmdd') >= '19700101' AND \t \traccolta in ('P','T','V','S') AND \tcod_flusso='VNO' AND \tstato IN ('4','5','6','7','8') ORDER by pod_id", exc.getMessage());
        }
    }
}

