/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.dao;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.RegimeContrattoCreator;
import biz.elabor.prebilling.common.model.RegimeContratto;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.ContrattoEle;
import biz.elabor.prebilling.dao.DataContratto;
import biz.elabor.prebilling.dao.DataContrattoCreator;
import biz.elabor.prebilling.dao.DatiMisura;
import biz.elabor.prebilling.dao.DatiMisuraCreator;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.PodConsumiCreator;
import biz.elabor.prebilling.dao.ResellerPodCreator;
import biz.elabor.prebilling.dao.creator.ContrattoEleCreator;
import biz.elabor.prebilling.dao.creator.FittiziaCreator;
import biz.elabor.prebilling.dao.creator.PodDateCreator;
import biz.elabor.prebilling.dao.creator.PraticaVoloCreator;
import biz.elabor.prebilling.dao.creator.RcuCreator;
import biz.elabor.prebilling.dao.creator.RigaPodCreator;
import biz.elabor.prebilling.model.PodMatricola;
import biz.elabor.prebilling.model.giada.Fittizia;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.Rcu;
import biz.elabor.prebilling.model.giada.RigaPod;
import biz.elabor.prebilling.services.letture.PodConsumi;
import biz.elabor.prebilling.services.reseller.ResellerPodMap;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.ConnectionManager;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.setmap.DefaultSetMapKey;
import org.homelinux.elabor.structures.setmap.SetMap;
import org.homelinux.elabor.tools.StringUtils;

public class JdbcGiadaDao
extends ConnectionManager
implements GiadaDao {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Map<String, String> PRESTAZIONI_CLAUSES = new HashMap<String, String>();
    private String queryRighePod;
    private String queryRighePodSingle;
    private String queryPiv;
    private String queryContrattiReseller;
    private String queryContrattiDispatcher;
    private String queryValiditaContratti;
    private String queryRcu;
    private String queryMatricolaFittizia;
    private String queryResellerPod;
    private String queryPivIV;
    private String queryFittizie;
    private String queryRegime;
    private String queryMesiRettificheDispatcherClear;
    private String queryMesiRettificheDispatcherPrep;
    private String queryMesiRettificheDispatcher;
    private String queryPodConsumi;
    private boolean hasPiv;
    private final String giadaUser;
    private final String misureUser;

    static {
        PRESTAZIONI_CLAUSES.put("VT3", "(cdunipre='VT3' OR (cdunipre='VT1' AND ccclaint<>27))");
        PRESTAZIONI_CLAUSES.put("VP3", "(cdunipre='VP3' OR (cdunipre='VP1' AND ccclaint<>27))");
    }

    public JdbcGiadaDao(PrebillingConfiguration configuration) throws IOException {
        super(configuration.getGiadaHost(), configuration.getGiadaType(), configuration.getGiadaDbName(), configuration.getGiadaDbUser(), configuration.getGiadaDbPassword());
        this.giadaUser = configuration.getGiadaDbUser();
        this.misureUser = configuration.getMisureDbUser();
        this.hasPiv = configuration.hasPiv();
        ClassLoader classLoader = JdbcGiadaDao.class.getClassLoader();
        this.queryRighePod = JdbcGiadaDao.loadTemplate(classLoader, "query-giada.sql");
        this.queryRighePodSingle = JdbcGiadaDao.loadTemplate(classLoader, "query-giada-single.sql");
        this.queryPiv = JdbcGiadaDao.loadTemplate(classLoader, "query-piv.sql");
        this.queryPivIV = JdbcGiadaDao.loadTemplate(classLoader, "query-piv-iv.sql");
        this.queryContrattiReseller = JdbcGiadaDao.loadTemplate(classLoader, "query-contratti-reseller.sql");
        this.queryContrattiDispatcher = JdbcGiadaDao.loadTemplate(classLoader, "query-contratti.sql");
        this.queryValiditaContratti = JdbcGiadaDao.loadTemplate(classLoader, "query-validita-contratti.sql");
        this.queryRcu = JdbcGiadaDao.loadTemplate(classLoader, "query-rcu.sql");
        this.queryMatricolaFittizia = JdbcGiadaDao.loadTemplate(classLoader, "query-matricola-fittizia.sql");
        this.queryResellerPod = JdbcGiadaDao.loadTemplate(classLoader, "query-reseller-pod.sql");
        this.queryFittizie = JdbcGiadaDao.loadTemplate(classLoader, "query-pod-matricola-fittizia.sql");
        this.queryRegime = JdbcGiadaDao.loadTemplate(classLoader, "query-regime.sql");
        this.queryMesiRettificheDispatcher = JdbcGiadaDao.loadTemplate(classLoader, "query-mesi-rettifiche-dispatcher.sql");
        this.queryMesiRettificheDispatcherClear = JdbcGiadaDao.loadTemplate(classLoader, "query-mesi-rettifiche-dispatcher-clear.sql");
        this.queryMesiRettificheDispatcherPrep = JdbcGiadaDao.loadTemplate(classLoader, "query-mesi-rettifiche-dispatcher-prep.sql");
        this.queryPodConsumi = JdbcGiadaDao.loadTemplate(classLoader, "query-pod-consumi.sql");
    }

    @Override
    public List<RigaPod> getRighePod(int anno, Month mese, String cclettur) {
        return this.getRighePod(anno, mese, cclettur, "", null, Integer.MAX_VALUE);
    }

    @Override
    public List<RigaPod> getRighePod(int anno, Month mese, String cclettur, String startPod, String onlyPod, int maxRows) {
        String template = onlyPod == null || onlyPod.trim().isEmpty() ? this.queryRighePod.replaceAll(":codicepod-clause:", "cdprerif >= '" + startPod + "' and rownum <= :maxrow") : this.queryRighePodSingle.replaceAll(":cdprerif", "'" + onlyPod.trim() + "'");
        QueryTemplate query = new QueryTemplate(template);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        query.replace(":startpod:", startPod);
        query.replace(":start_date", startDate, DATE_FORMAT);
        query.replace(":end_date", endDate, DATE_FORMAT);
        query.replace(":cclettur", cclettur);
        query.replace(":ccletape", "10");
        query.replace(":maxrow", maxRows);
        RigaPodCreator creator = new RigaPodCreator();
        return this.getRecords(query, creator);
    }

    public ListMapKey<String, PraticaVolo> getPiv(Iterable<String> cdunipre, Date endDate, String azienda, String codicePod) {
        DefaultListMapKey<String, PraticaVolo> piv = new DefaultListMapKey<String, PraticaVolo>();
        if (this.hasPiv) {
            String template = JdbcGiadaDao.handlePrestazioniClause(this.queryPiv, cdunipre);
            template = JdbcGiadaDao.replacePodClause(template, codicePod);
            template = JdbcGiadaDao.replaceClause(template, "azienda-clause", "cdanagra", azienda);
            QueryTemplate query = new QueryTemplate(template);
            query.replace(":data:", endDate, DATE_FORMAT);
            PraticaVoloCreator creator = new PraticaVoloCreator();
            this.buildClassifier(piv, query, creator);
        }
        return piv;
    }

    private static String handlePrestazioniClause(String template, Iterable<String> cdunipre) {
        String prestazioniClause = "";
        for (String prestazione : cdunipre) {
            String currentClause;
            if (!prestazioniClause.isEmpty()) {
                prestazioniClause = String.valueOf(prestazioniClause) + " OR ";
            }
            if ((currentClause = PRESTAZIONI_CLAUSES.get(prestazione)) == null) {
                currentClause = "cdunipre='" + prestazione + "'";
            }
            prestazioniClause = String.valueOf(prestazioniClause) + currentClause;
        }
        return template.replaceAll("prestazioni-clause", prestazioniClause);
    }

    @Override
    public List<PodMatricola> getPodMatricolaFittizia(String reseller) {
        String template = this.queryMatricolaFittizia;
        template = reseller.isEmpty() ? template.replace("<azienda-clause>", "") : template.replace("<azienda-clause>", "WHERE azienda=:reseller:");
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":reseller:", reseller);
        PodDateCreator creator = new PodDateCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<ContrattoEle> getContrattiDispatcher(int anno, Month mese, Set<String> podSet) {
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        return this.getContratti(anno, mese, podSet, this.queryContrattiDispatcher, dateFormat);
    }

    @Override
    public List<ContrattoEle> getContrattiReseller(int anno, Month mese, Set<String> podSet) {
        DateFormat dateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        return this.getContratti(anno, mese, podSet, this.queryContrattiReseller, dateFormat);
    }

    private List<ContrattoEle> getContratti(int anno, Month mese, Set<String> podSet, String masterTemplate, DateFormat dateFormat) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        ContrattoEleCreator creator = new ContrattoEleCreator();
        String template = masterTemplate.replaceAll("pod-clause", "cdprerif in (:codici:) AND");
        template = JdbcGiadaDao.replaceClause(template, "azienda-clause", "cdazirif", "");
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":codici:", podSet);
        query.replace(":start_date", startDate, dateFormat);
        query.replace(":end_date", endDate, dateFormat);
        query.replace(":mese_rif", startDate, dateFormat);
        return this.getRecords(query, creator);
    }

    @Override
    public List<ContrattoEle> getContrattiDispatcher(int anno, Month mese, String codicePod, String codiceReseller) {
        ContrattoEleCreator creator = new ContrattoEleCreator();
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        return this.getContratti(anno, mese, codicePod, codiceReseller, this.queryContrattiDispatcher, dateFormat, creator);
    }

    @Override
    public List<ContrattoEle> getContrattiReseller(int anno, Month mese, String codicePod, String codiceReseller) {
        ContrattoEleCreator creator = new ContrattoEleCreator();
        DateFormat dateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        return this.getContratti(anno, mese, codicePod, codiceReseller, this.queryContrattiReseller, dateFormat, creator);
    }

    @Override
    public Map<String, DataContratto> getContrattiReseller(Date startDate) {
        DateFormat dateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        return this.getContratti(startDate, this.queryContrattiReseller, dateFormat);
    }

    @Override
    public Map<String, DataContratto> getContrattiDispatcher(Date startDate) {
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        DataContrattoCreator creator = new DataContrattoCreator();
        Date endDate = CalendarTools.getEndOfTime();
        List<DataContratto> items = this.getContratti(startDate, endDate, "", "", this.queryValiditaContratti, dateFormat, creator);
        LinkedHashMap<String, DataContratto> contratti = new LinkedHashMap<String, DataContratto>();
        StructuresHelper.buildMap(contratti, items);
        return contratti;
    }

    private Map<String, DataContratto> getContratti(Date startDate, String template, DateFormat dateFormat) {
        String query = "select cdprerif, min(dtvalidi) as dtvalidi from (" + JdbcGiadaDao.replacePodClause(template, "") + ") group by cdprerif order by cdprerif";
        Date endDate = CalendarTools.getEndOfTime();
        DataContrattoCreator creator = new DataContrattoCreator();
        List<DataContratto> items = this.getContratti(startDate, endDate, "", "", query, dateFormat, creator);
        LinkedHashMap<String, DataContratto> contratti = new LinkedHashMap<String, DataContratto>();
        StructuresHelper.buildMap(contratti, items);
        return contratti;
    }

    private <T> List<T> getContratti(int anno, Month mese, String codicePod, String codiceReseller, String template, DateFormat dateFormat, RecordCreator<T> creator) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        return this.getContratti(startDate, endDate, codicePod, codiceReseller, template, dateFormat, creator);
    }

    private <T> List<T> getContratti(Date startDate, Date endDate, String codicePod, String codiceReseller, String template, DateFormat dateFormat, RecordCreator<T> creator) {
        String templateElaborato = JdbcGiadaDao.replacePodClause(template, codicePod);
        templateElaborato = JdbcGiadaDao.replaceClause(templateElaborato, "azienda-clause", "cdazirif", codiceReseller);
        QueryTemplate query = new QueryTemplate(templateElaborato);
        query.replace(":start_date", startDate, dateFormat);
        query.replace(":end_date", endDate, dateFormat);
        DateFormat annoMeseFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        query.replace(":mese_rif", startDate, annoMeseFormat);
        return this.getRecords(query, creator);
    }

    private static String replacePodClause(String template, String pod) {
        return JdbcGiadaDao.replaceClause(template, "pod-clause", "cdprerif", pod);
    }

    private static String replaceClause(String template, String placeHolder, String field, String value) {
        String trim = value.trim();
        String clause = trim.isEmpty() ? "" : String.valueOf(field) + "='" + trim + "' AND";
        return template.replaceAll(placeHolder, clause);
    }

    @Override
    public Rcu getRcu(String codicePod, Date data) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate(this.queryRcu);
        query.replace(":codice_pod:", codicePod);
        DateFormat monthFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        query.replace(":annomese:", data, monthFormat);
        RcuCreator creator = new RcuCreator();
        return this.getRecord(query, creator, null, null);
    }

    @Override
    public ResellerPodMap getResellerPod(int anno, Month mese) {
        ResellerPodMap map = new ResellerPodMap();
        QueryTemplate query = new QueryTemplate(this.queryResellerPod);
        ResellerPodCreator creator = new ResellerPodCreator();
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        query.replace(":data_start", startDate, DATE_FORMAT);
        query.replace(":data_end", endDate, DATE_FORMAT);
        this.buildClassifier(map, query, creator);
        return map;
    }

    @Override
    public List<PraticaVolo> getPivVoltureIV(String onlyPod, Date dataFine) {
        String template = JdbcGiadaDao.replacePodClause(this.queryPivIV, onlyPod);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":data:", dataFine, DATE_FORMAT);
        PraticaVoloCreator creator = new PraticaVoloCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Fittizia> getFittizie(String codicePod) {
        String template = JdbcGiadaDao.replacePodClause(this.queryFittizie, codicePod);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":ccletape", "10");
        query.replace(":end_date", new Date(), DATE_FORMAT);
        FittiziaCreator creator = new FittiziaCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<RegimeContratto> getContrattiNonRegime(Date date) {
        String template = this.queryRegime.replaceAll("%DB_GIADA", this.giadaUser).replaceAll("%DB_DIESIS", this.misureUser);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":end_date", date, DATE_FORMAT);
        RegimeContrattoCreator creator = new RegimeContrattoCreator(true);
        return this.getRecords(query, creator);
    }

    @Override
    public SetMap<Date, DatiMisura> getMesiRettificheDispatcher(int anno, Month mese, String onlyPod) {
        this.execute(this.queryMesiRettificheDispatcherClear);
        String podClause = StringUtils.isEmpty(onlyPod) ? "" : "where pod_id=:codice_pod:";
        String templatePrep = this.queryMesiRettificheDispatcherPrep.replaceAll("<pod-clause>", podClause).replaceAll("%DB_DIESIS", this.misureUser);
        QueryTemplate queryPrep = new QueryTemplate(templatePrep);
        Date endDate = CalendarTools.getNextMese(anno, mese);
        queryPrep.replace(":end_date", endDate, StrategyCommonHelper.getAnnoMeseDateFormat());
        queryPrep.replace(":codice_pod:", onlyPod);
        this.execute(queryPrep);
        String template = this.queryMesiRettificheDispatcher.replaceAll("%DB_DIESIS", this.misureUser);
        QueryTemplate query = new QueryTemplate(template);
        DatiMisuraCreator creator = new DatiMisuraCreator(anno, mese);
        List<DatiMisura> records = this.getRecords(query, creator);
        TreeMap storeMap = new TreeMap();
        DefaultSetMapKey<Date, DatiMisura> setMap = new DefaultSetMapKey<Date, DatiMisura>(storeMap);
        setMap.addAll(records);
        block0: for (Map.Entry entry : setMap.entrySet()) {
            StringBuffer pods = new StringBuffer();
            Set value = (Set)entry.getValue();
            int count = 0;
            for (DatiMisura pod : value) {
                pods.append(pod.getCodicePod());
                if (++count > 5) continue block0;
                pods.append("\t");
            }
        }
        return setMap;
    }

    @Override
    public List<PodConsumi> getPodConsumi(String codicePod, int anno, Month mese) {
        QueryTemplate query = new QueryTemplate(this.queryPodConsumi);
        query.replace(":codice_pod", codicePod);
        Date inizioMese = CalendarTools.getDate(anno, mese, 1);
        query.replace(":start_date", inizioMese, DATE_FORMAT);
        Date fineMese = CalendarTools.getEndDate(anno, mese);
        query.replace(":end_date", fineMese, DATE_FORMAT);
        PodConsumiCreator creator = new PodConsumiCreator();
        return this.getRecords(query, creator);
    }
}

