/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.config;

import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.config.FileConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.config.map.DefaultConfigurationInstance;
import biz.elabor.prebilling.dao.JdbcGiadaDao;
import biz.elabor.prebilling.dao.JdbcIndiciDao;
import biz.elabor.prebilling.dao.JdbcMisureDao;
import biz.elabor.prebilling.dao.JdbcPrebillingDao;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileConfigurationsLoader {
    private final File folder;
    private final String version;

    public FileConfigurationsLoader(File folder, String version) {
        this.folder = folder;
        this.version = version;
    }

    public ConfigurationInstance loadConfigurationInstance(String key) throws InvalidConfigurationException, IOException {
        return FileConfigurationsLoader.loadConfigurationInstance(key, this.folder, this.version);
    }

    public static ConfigurationInstance loadConfigurationInstance(String key, File folder, String version) throws InvalidConfigurationException, IOException {
        DefaultConfigurationInstance configurationInstance;
        Logger logger = Logger.getLogger(FileConfiguration.class.getName());
        try {
            String fileName = String.valueOf(key) + ".cfg";
            FileConfiguration config = new FileConfiguration(folder, fileName, version);
            JdbcPrebillingDao prebillingDao = new JdbcPrebillingDao(config);
            JdbcMisureDao misureDao = new JdbcMisureDao(config);
            JdbcGiadaDao giadaDao = new JdbcGiadaDao(config);
            JdbcIndiciDao indiciDao = new JdbcIndiciDao(config);
            configurationInstance = new DefaultConfigurationInstance(prebillingDao, misureDao, giadaDao, indiciDao, config);
            logger.info("caricata configurazione " + key);
            logger.info("aperta connessione " + config.getPrebillingDbName() + "/" + config.getPrebillingDbUser());
            logger.info("aperta connessione " + config.getMisureDbName() + "/" + config.getMisureDbUser());
            logger.info("aperta connessione " + config.getGiadaDbName() + "/" + config.getGiadaDbUser());
            logger.info("aperta connessione " + config.getIndiciDbName() + "/" + config.getIndiciDbUser());
        }
        catch (RuntimeException exc) {
            logger.log(Level.SEVERE, exc.toString());
            throw new InvalidConfigurationException(key);
        }
        return configurationInstance;
    }
}

