/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.config;

import biz.elabor.prebilling.common.config.BasicFileConfiguration;
import biz.elabor.prebilling.config.CdConMag;
import biz.elabor.prebilling.config.Generazione;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.services.StrategyHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.structures.safe.BasicSafeMap;
import org.homelinux.elabor.structures.safe.LabelMapError;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.StringUtils;

public class FileConfiguration
extends BasicFileConfiguration
implements PrebillingConfiguration {
    private static final String PREFIX = "cdconmag.";
    private static final List<String> ID_FLUSSI = Arrays.asList("rsn", "rnv_iv", "rnv", "rno", "rfo", "int", "dsr", "avr", "vpr");
    private static final List<String> ID_FLUSSI_O2GR = Arrays.asList("pdo2gr", "rfo2gr");
    private SafeMap<String, CdConMag> directMap;

    public FileConfiguration(File mainFolder, String fileName, String version) throws IOException {
        this(mainFolder, Arrays.asList(new File(mainFolder, fileName)), version);
    }

    public FileConfiguration(File mainFolder, List<File> files, String version) throws IOException {
        super(mainFolder, files, version);
        this.loadCdConMag();
    }

    private void loadCdConMag() {
        LabelMapError error = new LabelMapError("cdconmag");
        this.directMap = new BasicSafeMap<String, CdConMag>(error);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(PREFIX)) continue;
            String stringValue = this.properties.getProperty(key);
            key = key.substring(PREFIX.length());
            String[] split = stringValue.split(",");
            String value = split[0];
            Generazione generazione = split.length > 1 ? Generazione.valueOf(split[1]) : Generazione.G1;
            CdConMag cdConMag = new CdConMag(key, value, generazione);
            this.directMap.add(key, cdConMag);
        }
    }

    @Override
    public boolean hasCrm() {
        String booleanTxt = this.properties.getProperty("dispatcher.crm", "true");
        return Boolean.valueOf(booleanTxt);
    }

    @Override
    public boolean hasPerdite() {
        String booleanTxt = this.properties.getProperty("mostra.perdite", "false");
        return Boolean.valueOf(booleanTxt);
    }

    @Override
    public boolean hasDettaglioDispatcher() {
        String booleanTxt = this.properties.getProperty("dettaglio.dispatcher", "true");
        return Boolean.valueOf(booleanTxt);
    }

    @Override
    public boolean hasDettaglioReseller() {
        String booleanTxt = this.properties.getProperty("dettaglio.reseller", "false");
        return Boolean.valueOf(booleanTxt);
    }

    @Override
    public File getDispatcherOutputFolder() {
        return this.getFolder("dispatcher.output.folder", "dispatcher");
    }

    @Override
    public File getMiddlewareOutputFolder() {
        return this.getFolder("middleware.output.folder", "middleware");
    }

    @Override
    public String getCclettur() {
        return this.properties.getProperty("cclettur", "23");
    }

    @Override
    public String getCdmeslet(String flusso, boolean stimata, boolean orario, boolean rettifica, boolean smis) {
        String cdmeslet;
        if (stimata) {
            if (orario) {
                boolean regime = flusso.equalsIgnoreCase("pdo2gR");
                cdmeslet = this.properties.getProperty("cdmesletO" + (regime ? "R" : "N"), "0050");
            } else {
                cdmeslet = this.properties.getProperty("cdmesletN", "0050");
            }
        } else if (rettifica && ID_FLUSSI_O2GR.contains(flusso.toLowerCase())) {
            cdmeslet = this.properties.getProperty("cdmesrfo2g", "0000");
        } else if (StrategyHelper.MOROSITA.contains(flusso.toUpperCase().substring(0, 2))) {
            cdmeslet = this.properties.getProperty("cdmesrno", "0000");
        } else if (rettifica && flusso.toLowerCase().startsWith("pno")) {
            cdmeslet = this.properties.getProperty("cdmespno", "0000");
        } else if (smis) {
            cdmeslet = this.properties.getProperty("cdmesmis", "0000");
        } else {
            cdmeslet = this.getCdmeslet(flusso, ID_FLUSSI, "0000");
            if (cdmeslet == null) {
                cdmeslet = "0000";
            }
        }
        return cdmeslet;
    }

    @Override
    public String getPrebillingHost() {
        return this.properties.getProperty("prebilling.dbHost");
    }

    @Override
    public DbmsType getPrebillingType() {
        return DbmsType.valueOf(this.properties.getProperty("prebilling.dbType"));
    }

    @Override
    public String getPrebillingDbName() {
        return this.properties.getProperty("prebilling.dbName");
    }

    @Override
    public String getPrebillingDbUser() {
        return this.properties.getProperty("prebilling.dbUser");
    }

    @Override
    public String getPrebillingDbPassword() {
        return this.properties.getProperty("prebilling.dbPass");
    }

    @Override
    public boolean hasPiv() {
        return this.properties.getProperty("giada.piv", "false").equalsIgnoreCase("true");
    }

    @Override
    public boolean isTrunking() {
        return this.properties.getProperty("truncate.energy", "false").equalsIgnoreCase("true");
    }

    @Override
    public File getInputFolder() {
        return this.getFolder("input.folder", "input");
    }

    @Override
    public String getIndiciHost() {
        return this.properties.getProperty("indici.dbHost");
    }

    @Override
    public DbmsType getIndiciDbmsType() {
        return DbmsType.valueOf(this.properties.getProperty("indici.dbType"));
    }

    @Override
    public String getIndiciDbName() {
        return this.properties.getProperty("indici.dbName");
    }

    @Override
    public String getIndiciDbUser() {
        return this.properties.getProperty("indici.dbUser");
    }

    @Override
    public String getIndiciDbPassword() {
        return this.properties.getProperty("indici.dbPass");
    }

    @Override
    public String getCifreStd() {
        return this.properties.getProperty("cifre.standard", "6");
    }

    @Override
    public String getCodiceDispatcher() {
        return this.properties.getProperty("codice.dispatcher", "");
    }

    @Override
    public double getCoeffUMPrezzi() {
        return this.getDouble("coeff.um.prezzi", "1");
    }

    @Override
    public Set<String> getTarDisDom() {
        String tarDisDomStr = this.properties.getProperty("tar_dis_dom", "D2,D3,TDR,TDNR,TDPC");
        String[] split = tarDisDomStr.replaceAll(" ", "").split(",");
        return new HashSet<String>(Arrays.asList(split));
    }

    @Override
    public String getPivaDistributoreVoltureSpeciale() {
        return this.properties.getProperty("piva.distributore.volture", "");
    }

    @Override
    public int getMaxRows() {
        String value = this.properties.getProperty("pod.maxrows", "200000");
        return Integer.parseInt(value);
    }

    @Override
    public Set<String> getPrestazioniIgnorate() {
        String tarDisDomStr = this.properties.getProperty("ignore.prestazioni", "APN,APR");
        String[] split = tarDisDomStr.replaceAll(" ", "").split(",");
        return new HashSet<String>(Arrays.asList(split));
    }

    @Override
    public String getIdCalendarioArera() {
        return this.properties.getProperty("calendario.arera", "1");
    }

    @Override
    public int getDefaultCifreContatore() {
        return Integer.parseInt(this.properties.getProperty("cifre.contatore", "6"));
    }

    private int getNCifre(String name, double k2) {
        String suffix = FileConfiguration.getSuffix(k2);
        String paramName = "ncifre" + suffix + "." + name;
        String property = this.properties.getProperty(paramName);
        if (StringUtils.isEmpty(property)) {
            property = suffix.isEmpty() ? "0" : this.properties.getProperty("ncifre." + name, "0");
        }
        int value = Integer.parseInt(property);
        return value;
    }

    private static String getSuffix(double k2) {
        return k2 == 1.0 ? "_K1" : "";
    }

    @Override
    public int getNCifreAttiva(double k2) {
        return this.getNCifre("attiva", k2);
    }

    @Override
    public int getNCifreReattiva(double k2) {
        return this.getNCifre("reattiva", k2);
    }

    @Override
    public int getNCifrePotenza(double k2) {
        return this.getNCifre("potenza", k2);
    }

    @Override
    public boolean handleCoeffTrasf() {
        return this.properties.getProperty("export.coefftrasf", "true").equalsIgnoreCase("true");
    }

    @Override
    public CdConMag getCdConMag(String cdConMagKey) {
        CdConMag cdConMag;
        try {
            cdConMag = (CdConMag)this.directMap.get(cdConMagKey);
        }
        catch (DataNotFoundException exc) {
            cdConMag = new CdConMag(cdConMagKey, "99999", Generazione.G1);
        }
        return cdConMag;
    }

    @Override
    public int getPrefixLength() {
        return Integer.parseInt(this.properties.getProperty("podprefix.length", "8"));
    }

    @Override
    public int getXmlPrefixLength() {
        return Integer.parseInt(this.properties.getProperty("xmlprefix.length", "8"));
    }

    @Override
    public String getDefaultAzienda() {
        return this.properties.getProperty("default.cdaziend", "default");
    }

    @Override
    public int getCifreTariffe() {
        return Integer.parseInt(this.properties.getProperty("cifre.tariffe", "5"));
    }

    @Override
    public int getXmlMaxSize() {
        return Integer.parseInt(this.properties.getProperty("xml.max.size", "20000000"));
    }

    @Override
    public int getGgcoflet() {
        return Integer.parseInt(this.properties.getProperty("ggcoflet", "30"));
    }

    @Override
    public int getContrattiBatchSize() {
        String value = this.properties.getProperty("batch.size", "900");
        return Integer.parseInt(value);
    }

    @Override
    public int getRitardoAzienda() {
        String value = this.properties.getProperty("default.cdaziend.giorni", "120");
        return Integer.parseInt(value);
    }

    @Override
    public int getMesiContrattiAttivi() {
        String value = this.properties.getProperty("mesi.contrattiattivi", "12");
        return Integer.parseInt(value);
    }

    @Override
    public int getMesiRitenzione() {
        String value = this.properties.getProperty("mesi.ritenzione", "4");
        return Integer.parseInt(value);
    }

    @Override
    public int getNumMaxMisureTariffe() {
        String value = this.properties.getProperty("max.misuretariffe", "100000");
        return Integer.parseInt(value);
    }

    @Override
    public boolean isConsumoComplessivo() {
        String booleanTxt = this.properties.getProperty("consumo.complessivo", "false");
        return Boolean.valueOf(booleanTxt);
    }

    @Override
    public int getMaxBatches() {
        String value = this.properties.getProperty("max.batches", "1000");
        return Integer.parseInt(value);
    }

    @Override
    public boolean isBatchCommit() {
        String booleanTxt = this.properties.getProperty("batch.commit", "false");
        return Boolean.valueOf(booleanTxt);
    }

    @Override
    public int getBatchAggregation() {
        String value = this.properties.getProperty("batch.aggregation", "1");
        return Integer.parseInt(value);
    }

    @Override
    public int getMaxPrefixCount() {
        String value = this.properties.getProperty("max.prefix.count", "100000");
        return Integer.parseInt(value);
    }

    @Override
    public String getUrlPrezziEle() {
        return this.properties.getProperty("url.prezzi.ele");
    }
}

