/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.config;

import biz.elabor.prebilling.common.FileCopyHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import java.io.File;
import org.homelinux.elabor.file.PatternFileFilter;

public class ConfigurationHelper {
    private static final String IMPORT = "import";
    private static final String XML = "xmldel65";
    private static final String LETTURE = "letture";
    private static final String DISPATCHER = "dispatcher";
    private static final String RESELLER = "reseller";
    private static final String MIDDLEWARE = "middleware";

    public static File getDispatcherTmpLettureFolder(PrebillingConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        File tmpDispatcherFolder = ConfigurationHelper.getDispatcherTmpFolder(configuration, idEsecuzione, funzionalita);
        File folder = new File(tmpDispatcherFolder, LETTURE);
        folder.mkdirs();
        return folder;
    }

    public static File getDispatcherTmpFolder(PrebillingConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        File funcTmpFolder = ConfigurationHelper.getTmpFolder(configuration, idEsecuzione, funzionalita);
        return new File(funcTmpFolder, DISPATCHER);
    }

    public static File getExecutionTmpFolder(PrebillingConfiguration configuration, String idEsecuzione) {
        File tmpFolder = configuration.getTmpFolder();
        File executionTmpFolder = new File(tmpFolder, idEsecuzione);
        return executionTmpFolder;
    }

    public static File getTmpFolder(PrebillingConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        File executionTmpFolder = ConfigurationHelper.getExecutionTmpFolder(configuration, idEsecuzione);
        return new File(executionTmpFolder, funzionalita.name().toLowerCase());
    }

    public static File getDispatcherTmpImportFolder(PrebillingConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        File dispatcherFolder = ConfigurationHelper.getDispatcherTmpFolder(configuration, idEsecuzione, funzionalita);
        File folder = new File(dispatcherFolder, IMPORT);
        folder.mkdirs();
        return folder;
    }

    public static File getDispatcherCodaTmpFolder(PrebillingConfiguration configuration, String idEsecuzione) {
        File codaRegimeFolder = FileCopyHelper.getCodaTmpFolder(configuration, idEsecuzione);
        File folder = new File(codaRegimeFolder, DISPATCHER.toUpperCase());
        folder.mkdirs();
        return folder;
    }

    public static File getResellerTmpImportFolder(PrebillingConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita, String destinazione) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita, "");
        String fixDestinazione = destinazione.isEmpty() ? "/import" : destinazione;
        File folder = new File(resellerFolder, fixDestinazione);
        folder.mkdirs();
        return folder;
    }

    public static File getResellerTmpImportFolder(PrebillingConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita) {
        return ConfigurationHelper.getResellerTmpImportFolder(configuration, idEsecuzione, azienda, funzionalita, "");
    }

    public static File getResellerTmpXmlFolder(PrebillingConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita, String suffix) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita, suffix);
        File folder = new File(resellerFolder, XML);
        folder.mkdirs();
        return folder;
    }

    public static File getResellerTmpLettureFolder(PrebillingConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita, "");
        File folder = new File(resellerFolder, LETTURE);
        folder.mkdirs();
        return folder;
    }

    public static File getResellerTmpFolder(PrebillingConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita, String suffix) {
        File tmpFolder = ConfigurationHelper.getTmpFolder(configuration, idEsecuzione, funzionalita);
        File tmpResellerFolder = new File(tmpFolder, "reseller-" + azienda + suffix);
        tmpResellerFolder.mkdirs();
        return tmpResellerFolder;
    }

    public static File getResellerFolder(PrebillingConfiguration configuration, String azienda) {
        File codaRegimeFolder = configuration.getCodaFolder();
        return new File(codaRegimeFolder, "reseller-" + azienda);
    }

    public static File getMiddlewareTmpFolder(PrebillingConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        File tmpFolder = ConfigurationHelper.getTmpFolder(configuration, idEsecuzione, funzionalita);
        File folder = new File(tmpFolder, MIDDLEWARE);
        folder.mkdirs();
        return folder;
    }

    public static File[] getResellerTmpFolders(PrebillingConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        PatternFileFilter resellerFilter = new PatternFileFilter("reseller-.*", "reseller file filter");
        File tmpFolder = ConfigurationHelper.getTmpFolder(configuration, idEsecuzione, funzionalita);
        return tmpFolder.listFiles(resellerFilter);
    }
}

