/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.utils;

import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.model.BasicContratto;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class AbstractRegimeService {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected Map<String, ListMap<String, Date>> regime;
    private final String header;

    protected abstract File getFolder(String var1, String var2, String var3);

    protected abstract Date getDataRegime(Date var1, Date var2);

    public AbstractRegimeService(String header) {
        this.header = header;
    }

    protected void initRegime() {
        this.regime = new HashMap<String, ListMap<String, Date>>();
    }

    protected void fillRegime(BasicContratto contratto, Date dataPrimaMisura, BasicServiceStatus status) {
        Date dataSospensione;
        if (dataPrimaMisura != null && ((dataSospensione = contratto.getDataSospensione()) == null || dataPrimaMisura.before(dataSospensione))) {
            Date dataInizio = contratto.getDataInizio();
            Date dataRegime = this.getDataRegime(dataPrimaMisura, dataInizio);
            String azienda = contratto.getReseller();
            String codicePdr = contratto.getCodice();
            this.fillRegime(azienda, codicePdr, dataRegime);
            status.count(azienda, "regime", 1);
        }
    }

    protected static Date getDataInizioMese(Date dataPrimaMisura) {
        Date dataInizioMese;
        ElaborCalendar calendar = new ElaborCalendar(dataPrimaMisura);
        if (calendar.getGiorno() == 1) {
            dataInizioMese = dataPrimaMisura;
        } else {
            calendar.addMesi(1);
            calendar.setGiorno(1);
            dataInizioMese = calendar.getDate();
        }
        return dataInizioMese;
    }

    protected void fillRegime(String azienda, String codicePdr, Date dataRegime) {
        ListMap<String, Date> regimeAzienda = this.regime.get(azienda);
        if (regimeAzienda == null) {
            regimeAzienda = new BasicListMap<String, Date>();
            this.regime.put(azienda, regimeAzienda);
        }
        regimeAzienda.add(codicePdr, dataRegime);
    }

    protected boolean exportRegime(String servizio, String target, BasicServiceStatus status) {
        boolean ok;
        try {
            String idEsecuzione = status.getIdEsecuzione();
            for (Map.Entry<String, ListMap<String, Date>> entry : this.regime.entrySet()) {
                String azienda = entry.getKey();
                ListMap<String, Date> regimeAzienda = entry.getValue();
                File folder = this.getFolder(idEsecuzione, azienda, target);
                String timestamp = this.getTimestamp();
                File file = new File(folder, "regime-" + azienda + servizio + timestamp + ".txt");
                this.exportRegime(file, regimeAzienda);
            }
            ok = true;
        }
        catch (FileNotFoundException exc) {
            status.getLogger().log(Level.SEVERE, "regime", exc);
            ok = false;
        }
        return ok;
    }

    protected String getTimestamp() {
        return this.timestampFormat.format(new Date());
    }

    private void exportRegime(File file, ListMap<String, Date> regimeAzienda) throws FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = new PrintWriter(file);){
            writer.println(this.header);
            this.printRegimeAzienda(regimeAzienda, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void printRegimeAzienda(ListMap<String, Date> regimeAzienda, PrintWriter writer) {
        for (Map.Entry entry : regimeAzienda.entrySet()) {
            String codicePdr = (String)entry.getKey();
            for (Date dataRegime : (List)entry.getValue()) {
                writer.println(String.valueOf(codicePdr) + ";" + this.dateFormat.format(dataRegime));
            }
        }
    }
}

