/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.model;

import biz.elabor.prebilling.common.model.BasicContratto;
import biz.elabor.prebilling.common.model.IdContratto;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;

public class Contratto
extends BasicContratto {
    private Date dataValidita;
    private int numFasce;
    private IdContratto idContratto;
    private int tipoApplicazione;
    private String cdindene;
    private Date dataScadenza;
    private Date dataRevoca;
    private String cdUteRif;
    private String codiceOfferta;
    private final double aqconsum;
    private final int livello;
    private final double qtconfla;
    private final Date dtmisora;
    private final double emtaruni;
    private final double emspread;
    private final double emspreneg;
    private final String cdindneg;
    private final boolean fixing;
    private final int tipoAppPenale;
    private final double qtconsum;
    private final double qtindene;
    private final Date dtindice;

    public Contratto(String codice, String reseller, Date dataValidita, int numFasce, IdContratto idContratto, int tipoApplicazione, String cdindene, Date dataSospensione, Date dataRevoca, Date dataInizio, Date dataFine, Date dataScadenza, String cdUteRif, String codiceOfferta, double aqconsum, int livello, double qtconfla, Date dtmisora, double emtaruni, double emspread, double emspreneg, String cdindneg, boolean fixing, int tipoAppPenale, double qtconsum, double qtindene, Date dtindice) {
        super(codice, reseller, dataInizio, dataFine, dataValidita, dataSospensione, null);
        this.dataValidita = dataValidita;
        this.numFasce = numFasce;
        this.idContratto = idContratto;
        this.tipoApplicazione = tipoApplicazione;
        this.cdindene = cdindene == null ? "" : cdindene;
        this.dataRevoca = dataRevoca;
        this.dataScadenza = dataScadenza;
        this.cdUteRif = cdUteRif;
        this.codiceOfferta = codiceOfferta;
        this.aqconsum = aqconsum;
        this.livello = livello;
        this.qtconfla = qtconfla;
        this.dtmisora = dtmisora;
        this.emtaruni = emtaruni;
        this.emspread = emspread;
        this.emspreneg = emspreneg;
        this.cdindneg = cdindneg == null ? "" : cdindneg;
        this.fixing = fixing;
        this.tipoAppPenale = tipoAppPenale;
        this.qtconsum = qtconsum;
        this.qtindene = qtindene;
        this.dtindice = dtindice;
    }

    public int getNumFasce() {
        return this.numFasce;
    }

    public int getTipoApplicazione() {
        return this.tipoApplicazione;
    }

    public Integer getCodAzienda() {
        return this.idContratto.getCodAzienda();
    }

    public Integer getCodZona() {
        return this.idContratto.getCodZona();
    }

    public Integer getCodUtente() {
        return this.idContratto.getCodUtente();
    }

    public String getCodIndiceEnergetico() {
        return this.cdindene;
    }

    public Date getDataRevoca() {
        return this.dataRevoca;
    }

    public Date getDataScadenza() {
        return this.dataScadenza;
    }

    public String getCdUteRif() {
        return this.cdUteRif;
    }

    public String getCodiceOfferta() {
        return this.codiceOfferta;
    }

    public double getAqconsum() {
        return this.aqconsum;
    }

    public int getLivello() {
        return this.livello;
    }

    public double getQtConFla() {
        return this.qtconfla;
    }

    public Date getDtMisOra() {
        return this.dtmisora;
    }

    public double getEmtaruni() {
        return this.emtaruni;
    }

    public double getEmspread() {
        return this.emspread;
    }

    public boolean isRegime(Date inizioMese) {
        Date data = CalendarTools.max(inizioMese, this.dataValidita);
        return this.dtmisora != null && !this.dtmisora.after(data);
    }

    public double getEmspreneg() {
        return this.emspreneg;
    }

    public String getCdindneg() {
        return this.cdindneg;
    }

    public boolean isFixing() {
        return this.fixing;
    }

    public int getTipoAppPenale() {
        return this.tipoAppPenale;
    }

    public double getQtconsum() {
        return this.qtconsum;
    }

    public double getPrezzoMedio() {
        return this.qtindene;
    }

    public Date getDtindice() {
        return this.dtindice;
    }
}

