/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common;

import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import java.io.File;
import java.util.Date;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;

public abstract class AbstractCheckStatusStrategy {
    protected final String azienda;
    protected final String message;
    protected final TalkManager talkManager;

    protected abstract StatoElaborazione getStato() throws DataNotFoundException;

    protected abstract File getTmpFolder(String var1);

    protected abstract void saveStato(TipoStato var1, Date var2, String var3);

    public AbstractCheckStatusStrategy(String ambito, String message, TalkManager talkManager) {
        this.azienda = ambito;
        this.message = message;
        this.talkManager = talkManager;
    }

    protected boolean execute(Date date, String idEsecuzione) {
        boolean ok;
        TipoStato tipoStato;
        try {
            StatoElaborazione stato = this.getStato();
            tipoStato = stato.getTipoStato();
        }
        catch (DataNotFoundException exc) {
            tipoStato = TipoStato.NO_ESECUZIONE;
        }
        if (tipoStato.equals((Object)TipoStato.NO_ESECUZIONE)) {
            File[] files;
            File folder = this.getTmpFolder(idEsecuzione);
            if (!this.azienda.equals("*")) {
                folder = new File(folder, this.azienda);
            }
            if ((files = folder.listFiles()) == null || files.length == 0) {
                this.saveStato(TipoStato.IN_ESECUZIONE, date, idEsecuzione);
                ok = true;
            } else {
                Warning sentence = new Warning(this.message, "running.execution");
                this.talkManager.addSentence(sentence);
                ok = false;
            }
        } else {
            Warning sentence = new Warning(this.message, "running.execution");
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }
}

