/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model.rilevazioni;

import biz.elabor.misure.model.rilevazioni.AbstractRilevazione;
import biz.elabor.misure.model.rilevazioni.NullState;
import biz.elabor.misure.model.rilevazioni.RilevazioneOraria;
import biz.elabor.misure.model.rilevazioni.RilevazioneState;
import biz.elabor.misure.model.rilevazioni.RilevazioneStateVisitor;
import java.util.Calendar;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;

public class RilevazioneOrariaSolare<Pod>
extends AbstractRilevazione
implements RilevazioneOraria {
    private int giorno;
    private int ora;
    private double attiva;
    private double reattiva;
    private double potenza;
    private Pod pod;
    private RilevazioneState state;

    public RilevazioneOrariaSolare(int anno, Month mese, int giorno, int ora) {
        this.anno = anno;
        this.mese = mese;
        this.giorno = giorno;
        this.ora = ora;
        this.attiva = 0.0;
        this.potenza = 0.0;
        this.reattiva = 0.0;
        this.pod = null;
        this.state = new NullState(this);
    }

    @Override
    public double getPotenza() {
        return this.potenza;
    }

    @Override
    public void setPotenza(double potenza) {
        this.potenza = potenza;
    }

    @Override
    public RilevazioneState getState() {
        return this.state;
    }

    @Override
    public void setState(RilevazioneState state) {
        this.state = state;
    }

    @Override
    public void addCurva(RilevazioneOraria addendo, double mult) {
        this.attiva += addendo.getAttiva() * mult;
        this.reattiva += addendo.getReattiva() * mult;
        this.state.setAttiva();
    }

    @Override
    public double getAttiva() {
        return this.attiva;
    }

    @Override
    public void setAttiva(double valore) {
        this.attiva = valore;
        this.state.setAttiva();
    }

    @Override
    public int getGiorno() {
        return this.giorno;
    }

    @Override
    public void setGiorno(int giorno) {
        this.giorno = giorno;
    }

    @Override
    public int getOra() {
        return this.ora;
    }

    @Override
    public void setOra(int ora) {
        this.ora = ora;
    }

    @Override
    public double getReattiva() {
        return this.reattiva;
    }

    @Override
    public void setReattiva(double reattiva) {
        this.reattiva = reattiva;
    }

    public Pod getPod() {
        return this.pod;
    }

    public void setPod(Pod pod) {
        this.pod = pod;
    }

    @Override
    public Date getTime() {
        Calendar time = Calendar.getInstance();
        time.set(1, this.getAnno());
        time.set(2, this.getMese().ordinal());
        time.set(5, this.getGiorno());
        time.set(11, this.getOra() - 1);
        time.set(12, 0);
        time.set(13, 0);
        time.set(16, 0);
        return time.getTime();
    }

    @Override
    public void accept(RilevazioneStateVisitor visitor) {
        this.getState().accept(visitor);
    }

    @Override
    public int getOraLegale() {
        Date time = this.getTime();
        ElaborCalendar calendar = new ElaborCalendar(time);
        return calendar.getOra();
    }

    @Override
    public int getHourIndex() {
        return CalendarTools.getSolarHourIndex(this.anno, this.mese, this.giorno, this.ora);
    }
}

