/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model.rilevazioni;

import biz.elabor.misure.model.rilevazioni.CurvaGiornaliera;
import biz.elabor.misure.model.rilevazioni.CurvaMensile;
import biz.elabor.misure.model.rilevazioni.NullState;
import biz.elabor.misure.model.rilevazioni.RilevazioneOraria;
import biz.elabor.misure.model.rilevazioni.RilevazioneStateVisitor;
import biz.elabor.misure.model.rilevazioni.SetState;
import biz.elabor.misure.model.rilevazioni.StatoCurva;

public class CurveStateVisitor
implements RilevazioneStateVisitor {
    private int total = 0;
    private int empty = 0;
    private int filled = 0;
    private double totalAttiva = 0.0;
    private double totalReattiva = 0.0;

    public double getTotalReattiva() {
        return this.totalReattiva;
    }

    public double getTotalAttiva() {
        return this.totalAttiva;
    }

    public StatoCurva getStatoCurva() {
        StatoCurva stato = this.empty == this.total ? StatoCurva.MANCANTE : (this.filled == this.total ? StatoCurva.COMPLETA : StatoCurva.INCOMPLETA);
        return stato;
    }

    public void visit(CurvaMensile<?> mensile) {
        for (CurvaGiornaliera curvaGiornaliera : mensile) {
            this.visit(curvaGiornaliera);
        }
    }

    public void visit(CurvaGiornaliera<?> giornaliera) {
        for (RilevazioneOraria oraria : giornaliera) {
            oraria.accept(this);
            ++this.total;
            this.totalAttiva += oraria.getAttiva();
            this.totalReattiva += oraria.getReattiva();
        }
    }

    @Override
    public void visit(NullState state) {
        ++this.empty;
    }

    @Override
    public void visit(SetState state) {
        ++this.filled;
    }
}

