/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model.rilevazioni;

import biz.elabor.misure.model.rilevazioni.CurvaGiornaliera;
import biz.elabor.misure.model.rilevazioni.CurveStateVisitor;
import biz.elabor.misure.model.rilevazioni.RilevazioneOraria;
import biz.elabor.misure.model.rilevazioni.StatoCurva;
import java.util.Calendar;
import java.util.Date;
import org.homelinux.elabor.arrays.Accumulator;
import org.homelinux.elabor.arrays.AccumulatorSequence;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

public class CurvaMensile<Pod>
extends AccumulatorSequence<CurvaGiornaliera<Pod>>
implements Accumulator<CurvaMensile<Pod>> {
    private static final long serialVersionUID = 1L;
    private int anno;
    private Month mese;
    private boolean fromQuarti;

    public CurvaMensile(int anno, Month mese) {
        this(anno, mese, false);
    }

    public CurvaMensile(int anno, Month mese, boolean fromQuarti) {
        this.anno = anno;
        this.mese = mese;
        this.fromQuarti = fromQuarti;
        this.setup(CalendarTools.getDaysOfMonth(anno, mese));
    }

    public int getAnno() {
        return this.anno;
    }

    public Month getMese() {
        return this.mese;
    }

    @Override
    public void clear() {
        for (CurvaGiornaliera curvaGiornaliera : this) {
            curvaGiornaliera.clear();
        }
    }

    @Override
    public CurvaGiornaliera<Pod> createElement(int index) {
        return new CurvaGiornaliera(this.anno, this.mese, index + 1);
    }

    @Override
    public void addCurva(CurvaMensile<Pod> curva, double mult) {
        super.addCurva(curva, mult);
    }

    @Deprecated
    public void set(RilevazioneOraria rilevazione) {
        int annoSolare = rilevazione.getAnno();
        Month meseSolare = rilevazione.getMese();
        int giornoSolare = rilevazione.getGiorno();
        int oraSolare = rilevazione.getOra();
        int index = CalendarTools.getSolarHourIndex(annoSolare, meseSolare, giornoSolare, oraSolare);
        Date current = rilevazione.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(current);
        int giorno = calendar.get(5);
        CurvaGiornaliera giornaliera = (CurvaGiornaliera)this.get(giorno - 1);
        giornaliera.set(index, rilevazione);
    }

    public CurvaMensile<Pod> copy() {
        CurvaMensile<Pod> copy = new CurvaMensile<Pod>(this.anno, this.mese);
        for (CurvaGiornaliera template : this) {
            CurvaGiornaliera copiaGiorno = template.copy();
            copy.set(copiaGiorno.getGiorno() - 1, copiaGiorno);
        }
        return copy;
    }

    public StatoCurva getStato() {
        CurveStateVisitor visitor = new CurveStateVisitor();
        return this.getStato(visitor);
    }

    public StatoCurva getStato(CurveStateVisitor visitor) {
        visitor.visit(this);
        return visitor.getStatoCurva();
    }

    public boolean isComplete() {
        return this.getStato().equals((Object)StatoCurva.COMPLETA);
    }

    public double getTotal() {
        double total = 0.0;
        for (CurvaGiornaliera cg : this) {
            total += cg.getTotal();
        }
        return total;
    }

    public boolean isFromQuarti() {
        return this.fromQuarti;
    }
}

