/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model.fasce;

import biz.elabor.misure.model.fasce.CalendarioFasceGiornaliero;
import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.misure.model.fasce.FasciaOraria;
import org.homelinux.elabor.arrays.FixedLengthSequence;
import org.homelinux.elabor.calendar.Month;

public class CalendarioFasce
extends FixedLengthSequence<CalendarioFasceMensile> {
    private static final long serialVersionUID = 1L;
    private final int anno;
    private final String id;

    public CalendarioFasce(String id, int anno) {
        this.id = id;
        this.anno = anno;
        this.setup(Month.values().length);
    }

    public int getAnno() {
        return this.anno;
    }

    @Override
    public CalendarioFasceMensile createElement(int index) {
        return new CalendarioFasceMensile(this.id, this.anno, Month.values()[index]);
    }

    public void setFascia(Month mese, int giorno, int ora, FasciaOraria fascia) {
        CalendarioFasceMensile calendarioFasceMensile = this.getFasciaMensile(mese);
        CalendarioFasceGiornaliero giornaliera = calendarioFasceMensile.getFasciaGiornaliera(giorno);
        giornaliera.setFascia(ora, fascia);
    }

    public FasciaOraria getFascia(Month mese, int giorno, int ora) {
        CalendarioFasceMensile calendarioFasceMensile = this.getFasciaMensile(mese);
        CalendarioFasceGiornaliero giornaliera = calendarioFasceMensile.getFasciaGiornaliera(giorno);
        FasciaOraria oraria = giornaliera.getFascia(ora);
        return oraria;
    }

    private CalendarioFasceMensile getFasciaMensile(Month mese) {
        return (CalendarioFasceMensile)this.get(mese.ordinal());
    }

    public String getId() {
        return this.id;
    }
}

