/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.misure.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.homelinux.elabor.calendar.Month;

public class WorkingPeriod {
    private Calendar calendar;

    public WorkingPeriod() {
        this(Calendar.getInstance());
    }

    public WorkingPeriod(Date date) {
        this(WorkingPeriod.newCalendar(date));
    }

    public WorkingPeriod(Calendar calendar) {
        this.calendar = calendar;
        this.cleanPeriod();
    }

    public WorkingPeriod(int year, Month month) {
        this();
        this.calendar.set(1, year);
        this.calendar.set(2, month.ordinal());
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public WorkingPeriod shifted(int months) {
        Calendar previous = Calendar.getInstance();
        previous.setTime(this.calendar.getTime());
        previous.add(2, months);
        return new WorkingPeriod(previous);
    }

    public WorkingPeriod previous() {
        return this.shifted(-1);
    }

    public WorkingPeriod next() {
        return this.shifted(1);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public Month getMonth() {
        return Month.values()[this.calendar.get(2)];
    }

    public Date getStartDate() {
        Calendar copy = this.clone().getCalendar();
        copy.set(5, 1);
        return copy.getTime();
    }

    @Deprecated
    public Date getEndDate() {
        Calendar copy = this.clone().getCalendar();
        copy.add(2, 1);
        copy.add(14, -1);
        return copy.getTime();
    }

    public Date getEndTime() {
        Calendar copy = this.clone().getCalendar();
        copy.add(2, 1);
        copy.add(14, -1);
        return copy.getTime();
    }

    public Date getLastDate() {
        Calendar copy = this.clone().getCalendar();
        copy.add(2, 1);
        copy.add(5, -1);
        return copy.getTime();
    }

    public WorkingPeriod clone() {
        Calendar copy = (Calendar)this.calendar.clone();
        WorkingPeriod period = new WorkingPeriod(copy);
        return period;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMM yyyy");
        return formatter.format(this.getCalendar().getTime());
    }

    public String getName() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");
        return formatter.format(this.getCalendar().getTime());
    }

    public boolean equals(Object object) {
        boolean value;
        if (object instanceof WorkingPeriod) {
            WorkingPeriod wo = (WorkingPeriod)object;
            value = this.getYear() == wo.getYear() && this.getMonth() == wo.getMonth();
        } else {
            value = false;
        }
        return value;
    }

    public boolean covers(Date date) {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        return !(!startDate.before(date) && !startDate.equals(date) || !endDate.after(date) && !endDate.equals(date));
    }

    public int hashCode() {
        int code = this.getYear() * 100 + this.getMonth().ordinal();
        return Integer.valueOf(code).hashCode();
    }

    private static Calendar newCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private void cleanPeriod() {
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }
}

