/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.panel;

import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.homelinux.elabor.ui.Direction;
import org.homelinux.elabor.ui.RadioListener;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.RadioAreaButton;
import org.homelinux.elabor.ui.panel.RadioButtonListener;
import org.homelinux.elabor.ui.render.Renderer;

public class RadioArea<T extends Serializable>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<RadioAreaButton<T>> buttons;
    private List<RadioListener<T>> listeners = new ArrayList<RadioListener<T>>();

    public RadioArea(List<T> data, Renderer<T> renderer, Direction direction) {
        this.buttons = new ArrayList<RadioAreaButton<T>>();
        this.setLayout(new GridBagLayout());
        RadioButtonListener listener = new RadioButtonListener(this);
        int x = 0;
        int y = 0;
        for (Serializable item : data) {
            RadioAreaButton<Serializable> button = new RadioAreaButton<Serializable>(item, renderer);
            button.addItemListener(listener);
            this.buttons.add(button);
            UITools.addComponent(this, button, x, y, 1, 1, 1, 1, 1, 2);
            x = direction.nextX(x);
            y = direction.nextY(y);
        }
    }

    public void addRadioListener(RadioListener<T> listener) {
        this.listeners.add(listener);
    }

    public T getSelectedItem() {
        T selected = null;
        Iterator<RadioAreaButton<T>> iterator = this.buttons.iterator();
        while (selected == null && iterator.hasNext()) {
            RadioAreaButton<T> button = iterator.next();
            if (!button.isSelected()) continue;
            selected = button.getItem();
        }
        return selected;
    }

    public void setSelectedItem(T selectedItem) {
        Iterator<RadioAreaButton<T>> iterator = this.buttons.iterator();
        RadioAreaButton<T> selectedButton = null;
        while (selectedButton == null && iterator.hasNext()) {
            RadioAreaButton<T> button = iterator.next();
            T item = button.getItem();
            if (!item.equals(selectedItem)) continue;
            selectedButton = button;
        }
        if (selectedButton != null) {
            selectedButton.setSelected(true);
        }
        this.setSelectedButton(selectedButton);
    }

    protected void setSelectedButton(RadioAreaButton<T> source) {
        for (RadioAreaButton<T> button : this.buttons) {
            if (button.equals(source)) continue;
            button.setSelected(false);
        }
        this.fireSelectedItem(source);
    }

    private void fireSelectedItem(RadioAreaButton<T> button) {
        for (RadioListener<Object> radioListener : this.listeners) {
            Object item = button == null ? null : (Object)button.getItem();
            radioListener.itemSelected(item);
        }
    }
}

