/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.panel;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.SelectionListener;
import org.homelinux.elabor.ui.Selector;
import org.homelinux.elabor.ui.panel.AbstractGenericListModel;

public abstract class AbstractGenericSelectionModel<T>
extends AbstractGenericListModel<T>
implements GenericSelectionModel<T> {
    private static final long serialVersionUID = 1L;
    private Selector selector;
    private List<SelectionListener> listeners;

    public AbstractGenericSelectionModel(Selector selector) {
        this.selector = selector;
        this.listeners = new ArrayList<SelectionListener>();
    }

    public void unselectAll() {
        this.selector.unselectAll();
    }

    @Override
    public Object getSelectedItem() {
        return this.getSelectedElement();
    }

    @Override
    @Deprecated
    public void setSelectedItem(Object item) {
        this.setSelectedItem(item, true);
    }

    @Override
    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public void setSelectedItem(Object item, boolean notify) {
        int index = this.indexOf(item);
        this.setSelectedIndex(index, notify);
    }

    @Override
    public void addSelectedItem(Object item, boolean notify) {
        int index = this.indexOf(item);
        this.selector.addSelectedIndex(index, notify);
    }

    @Override
    public void removeSelectedItem(Object item, boolean notify) {
        int index = this.indexOf(item);
        this.selector.removeSelectedIndex(index, notify);
    }

    public void setSelectedIndex(int index, boolean notify) {
        int selectedIndex = this.selector.getSelectedIndex();
        if (selectedIndex != index) {
            this.selector.setSelectedIndex(index, notify);
            this.itemChanged();
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selector.getSelectedIndex();
    }

    private int[] getSelectedIndices() {
        return this.selector.getSelectedIndices();
    }

    @Override
    public T getSelectedElement() {
        int selectedIndex = this.getSelectedIndex();
        return selectedIndex >= 0 ? (T)this.get(selectedIndex) : null;
    }

    @Override
    public List<T> getSelectedElements() {
        int[] indices = this.getSelectedIndices();
        return this.get(indices);
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void selectionChanged(int[] selectedIndices) {
        this.selector.setSelectedIndices(selectedIndices, false);
        this.itemChanged();
        for (SelectionListener listener : this.listeners) {
            listener.selectionChanged(this);
        }
    }
}

