/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.DefaultPanel;

class AlphaColorChooserPanel
extends DefaultPanel<Color>
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private JColorChooser colorChooser = new JColorChooser();
    private JSlider slider;
    private Color color;

    public AlphaColorChooserPanel() {
        ColorSelectionModel selectionModel = this.colorChooser.getSelectionModel();
        selectionModel.addChangeListener(this);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.colorChooser, 0, 0, 3, 1, 100, 100, 1, 2);
        this.slider = new JSlider(0, 0, 255, 0);
        this.slider.setMajorTickSpacing(85);
        this.slider.setMinorTickSpacing(17);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        ClassLoader classLoader = this.getClass().getClassLoader();
        MessageCatalog catalog = new MessageCatalog(classLoader);
        String className = this.getClass().getName();
        catalog.loadCatalog(className);
        String alphaString = catalog.translate("alpha");
        TitledBorder border = BorderFactory.createTitledBorder(alphaString);
        this.slider.setBorder(border);
        this.slider.addChangeListener(this);
        UITools.addComponent(this, this.slider, 0, 1, 3, 1, 100, 1, 2, 2);
    }

    @Override
    public void setup(Color color) {
        this.color = color;
        this.colorChooser.setColor(color);
        int alpha = color == null ? 1 : color.getAlpha();
        this.slider.setValue(alpha);
    }

    @Override
    public boolean okAction() {
        boolean ok = super.okAction();
        if (ok) {
            this.color = this.getChooserColor();
        }
        return ok;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Color chooserColor = this.getChooserColor();
        this.colorChooser.setColor(chooserColor);
    }

    private Color getChooserColor() {
        Color chooserColor = this.colorChooser.getColor();
        int red = chooserColor.getRed();
        int green = chooserColor.getGreen();
        int blue = chooserColor.getBlue();
        int alpha = this.slider.getValue();
        chooserColor = new Color(red, green, blue, alpha);
        return chooserColor;
    }
}

