/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.homelinux.elabor.tools.XMLTreeNode;
import org.w3c.dom.Document;

public class XMLTreeModel
implements TreeModel {
    private Document document;
    private List<TreeModelListener> listeners;

    public XMLTreeModel(Document document) {
        this.document = document;
        this.listeners = new ArrayList<TreeModelListener>();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return parent instanceof XMLTreeNode ? ((XMLTreeNode)parent).getChild(index) : null;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        if (parent instanceof XMLTreeNode) {
            count = ((XMLTreeNode)parent).getChildCount();
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object node, Object child) {
        int index = -1;
        if (node instanceof XMLTreeNode && child instanceof XMLTreeNode) {
            XMLTreeNode xmlNode = (XMLTreeNode)node;
            XMLTreeNode xmlChild = (XMLTreeNode)child;
            index = xmlNode.getIndexOfChild(xmlChild);
        }
        return index;
    }

    @Override
    public Object getRoot() {
        return this.getXMLRoot();
    }

    public XMLTreeNode getXMLRoot() {
        return new XMLTreeNode(this.document.getDocumentElement());
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean leaf = false;
        if (node instanceof XMLTreeNode) {
            XMLTreeNode xmlNode = (XMLTreeNode)node;
            leaf = xmlNode.isLeaf();
        }
        return leaf;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    protected void fireTreeStructureChanged(XMLTreeNode node) {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{node});
        for (TreeModelListener tml : this.listeners) {
            tml.treeStructureChanged(event);
        }
    }

    public void treeModified() {
        this.fireTreeStructureChanged(this.getXMLRoot());
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }
}

