/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.tools.MissingPreferenceException;

public class Preferences
extends Properties {
    private static final long serialVersionUID = 1L;
    private String loadImpossibleString;
    private String doesntExistString;

    public Preferences() {
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(Preferences.class.getName());
        this.loadImpossibleString = catalog.translate("loadImpossible");
        this.doesntExistString = catalog.translate("doesntExist");
    }

    public void load(String defaultsFileName, String preferencesFileName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File defaultFolder = new File(".");
        this.load(defaultsFileName, preferencesFileName, defaultFolder, classLoader);
    }

    public void load(String defaultsFileName, String preferencesFileName, File preferencesFolder, ClassLoader classLoader) throws IOException {
        URL defaultsUrl = classLoader.getResource(defaultsFileName);
        if (defaultsUrl == null) {
            throw new IOException(this.loadImpossibleString + ": " + defaultsFileName);
        }
        this.load(defaultsUrl);
        if (preferencesFileName != null) {
            File preferencesFile;
            URL preferencesUrl = classLoader.getResource(preferencesFileName);
            if (preferencesUrl != null) {
                this.load(preferencesUrl);
            }
            if (preferencesFolder != null && (preferencesFile = new File(preferencesFolder, preferencesFileName)).exists()) {
                this.load(preferencesFile);
            }
        }
    }

    public void load(URL defaultsUrl) throws IOException {
        try (InputStream defaultsInputStream = defaultsUrl.openStream();){
            this.loadFromXML(defaultsInputStream);
        }
    }

    public void load(File file) throws IOException {
        try (FileInputStream defaultsInputStream = new FileInputStream(file);){
            this.loadFromXML(defaultsInputStream);
        }
    }

    public String getString(String name) throws MissingPreferenceException {
        String value = this.getProperty(name);
        if (value == null) {
            throw new MissingPreferenceException(this.doesntExistString + " " + name);
        }
        return value;
    }

    public boolean getBoolean(String name) throws MissingPreferenceException {
        String valueString = this.getString(name);
        boolean value = Boolean.parseBoolean(valueString);
        return value;
    }

    public int getInteger(String name) throws MissingPreferenceException {
        String valueString = this.getString(name);
        return Integer.parseInt(valueString);
    }

    public double getDouble(String name) throws MissingPreferenceException {
        String valueString = this.getString(name);
        double value = Double.parseDouble(valueString);
        return value;
    }

    public float getFloat(String name) throws MissingPreferenceException {
        float value = 0.0f;
        String valueString = this.getString(name);
        try {
            value = Float.parseFloat(valueString);
        }
        catch (Exception exc) {
            value = 0.0f;
        }
        return value;
    }

    public Color getColor(String name) throws MissingPreferenceException {
        String colorString = this.getString(name);
        String[] colorComponents = colorString.split(":", 3);
        int red = Integer.parseInt(colorComponents[0]);
        int green = Integer.parseInt(colorComponents[1]);
        int blue = Integer.parseInt(colorComponents[2]);
        Color color = new Color(red, green, blue);
        return color;
    }

    public <E extends Enum<E>> E getEnum(Class<E> enumClass, String name) throws MissingPreferenceException {
        String value = this.getString(name);
        return Enum.valueOf(enumClass, value.toUpperCase());
    }

    public File getFile(String name) throws MissingPreferenceException {
        String value = this.getString(name);
        return new File(value);
    }

    public File getFile(File parent, String name) throws MissingPreferenceException {
        String value = this.getString(name);
        return new File(parent, value);
    }
}

