/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class Cache<K, D extends Serializable> {
    private static final String NOT_A_DIRECTORY = "non \u00e8 una directory";
    private static final String SAVE_IMPOSSIBLE = "Impossibile salvare il file";
    private static final String LOAD_IMPOSSIBLE = "Impossibile caricare il file";
    private Map<K, D> memoryCache;
    private TreeMap<Long, K> dates;
    private int maxSize;
    private File directory;

    public Cache(File directory, int maxSize) {
        this.directory = directory;
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            JOptionPane.showMessageDialog(null, this.directory.getName() + " " + NOT_A_DIRECTORY);
        }
        this.maxSize = maxSize;
        this.memoryCache = new HashMap<K, D>();
        this.dates = new TreeMap();
    }

    public synchronized void put(K key, D data) {
        this.memoryPut(key, data);
        this.save(key, data);
    }

    public D get(K key) {
        Serializable data = (Serializable)this.memoryCache.get(key);
        if (data == null) {
            data = this.load(key);
        }
        return (D)data;
    }

    public void memoryPut(K key, D data) {
        while (this.memoryCache.size() > this.maxSize) {
            Long removeDate = this.dates.firstKey();
            K removeKey = this.dates.get(removeDate);
            this.memoryCache.remove(removeKey);
            this.dates.remove(removeDate);
        }
        this.memoryCache.put(key, data);
        long time = new Date().getTime();
        Long date = time;
        while (this.dates.get(date) != null) {
            time = date + 1L;
            date = time;
        }
        this.dates.put(date, (Long)key);
    }

    private void save(K key, D data) {
        if (this.directory != null) {
            try {
                File saveFile = this.getFile(key);
                try (FileOutputStream fos = new FileOutputStream(saveFile);
                     ObjectOutputStream oos = new ObjectOutputStream(fos);){
                    oos.writeObject(data);
                }
            }
            catch (IOException exception) {
                this.showMessage(key, exception, SAVE_IMPOSSIBLE);
            }
        }
    }

    private void showMessage(K key, Exception exception, String message) {
        JOptionPane.showMessageDialog(null, message + " " + key + "(" + exception.getMessage() + ")");
    }

    private File getFile(K key) throws UnsupportedEncodingException {
        return new File(this.directory, URLEncoder.encode(key.toString(), "utf-8"));
    }

    private D load(K key) {
        Serializable data;
        block12: {
            data = null;
            try {
                File saveFile = this.getFile(key);
                if (!saveFile.exists()) break block12;
                try (FileInputStream fis = new FileInputStream(saveFile);
                     ObjectInputStream ois = new ObjectInputStream(fis);){
                    data = (Serializable)ois.readObject();
                }
            }
            catch (Exception exception) {
                this.showMessage(key, exception, LOAD_IMPOSSIBLE);
            }
        }
        return (D)data;
    }
}

