/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.homelinux.elabor.structures.IteratorStatus;
import org.homelinux.elabor.structures.KeyRecord;

class Subiterator<K, T extends KeyRecord<K>>
implements Iterator<T> {
    private final IteratorStatus<T> status;
    private final K key;

    public Subiterator(IteratorStatus<T> status) {
        this.status = status;
        KeyRecord next = (KeyRecord)status.getNextItem();
        this.key = next == null ? null : next.getKey();
    }

    @Override
    public boolean hasNext() {
        KeyRecord next = (KeyRecord)this.status.getNextItem();
        return this.checkNext(next);
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyRecord next = (KeyRecord)this.status.getNextItem();
        if (this.checkNext(next)) {
            this.status.advance();
        }
        return (T)next;
    }

    private boolean checkNext(T next) {
        return next == null ? false : next.getKey().equals(this.key);
    }
}

