/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlConvert {
    private static final String SCHEMA = "file:prova.xsd";
    private DocumentBuilder docBuilder;
    private Transformer transformer;
    private Validator validator;

    public static void main(String[] args) throws ParserConfigurationException, TransformerException, IOException, SAXException {
        File file = new File("prova.xml");
        XmlConvert xmlCovert = new XmlConvert();
        xmlCovert.convert(file);
        xmlCovert.print(file);
    }

    private XmlConvert() throws ParserConfigurationException, TransformerConfigurationException, MalformedURLException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setValidating(false);
        this.docBuilder = dbFactory.newDocumentBuilder();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.transformer = transformerFactory.newTransformer();
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = new URL(SCHEMA);
        Schema schema = schemaFactory.newSchema(schemaUrl);
        this.validator = schema.newValidator();
    }

    public void convert(File file) throws TransformerException, IOException, SAXException {
        Document document = this.newDocument();
        DOMSource source = new DOMSource(document);
        this.validator.validate(source);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream stream = new FileOutputStream(file);){
            StreamResult result = new StreamResult(stream);
            this.transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Document newDocument() {
        Document document = this.docBuilder.newDocument();
        Element element = document.createElement("prova");
        document.appendChild(element);
        return document;
    }

    private void print(File file) throws SAXException, IOException, TransformerException {
        Document document = this.docBuilder.parse(file);
        DOMSource source = new DOMSource(document);
        this.validator.validate(source);
        StreamResult result = new StreamResult(System.out);
        this.transformer.transform(source, result);
    }
}

