/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.utils;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.services.EditionManager;

public class OntologyReferenceFix {
    private EditionManager editionManager = EditionManager.getInstance();
    private Edition edition;
    private File editionFile;
    private Ontology ontology;

    public static void main(String[] args) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (fileChooser.showOpenDialog(null) == 0) {
                File editionFile = fileChooser.getSelectedFile();
                OntologyReferenceFix orf = new OntologyReferenceFix(editionFile);
                orf.fix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OntologyReferenceFix(File editionFile) {
        this.editionFile = editionFile;
    }

    public void fix() {
        this.caricaEdizione();
        this.caricaOntologia();
        this.ricercaEModifica();
        this.registra();
    }

    private void ricercaEModifica() {
        Content content = this.edition.getContent();
        List<Variant> variants = content.getVariants();
        for (Variant variant : variants) {
            List<VariantItem> vItems = variant.getVariantItems();
            for (VariantItem vItem : vItems) {
                List<Description> descriptions = vItem.getDescriptions();
                for (Description description : descriptions) {
                    List<DescriptionItem> dItems = description.getItems();
                    for (DescriptionItem dItem : dItems) {
                        OntologyReference oRef = dItem.getOntologyReference();
                        if (oRef == null) continue;
                        this.fixOR(oRef);
                    }
                }
            }
        }
        System.out.println("Ricerca e modifica completata");
    }

    private void fixOR(OntologyReference ref) {
        OntologyClass oClass = this.ontology.getOntologyClassByComment(ref.getOntologyId());
        if (oClass == null) {
            System.out.println("commento non trovato: " + ref.getOntologyId());
        } else {
            System.out.println(String.valueOf(ref.getOntologyId()) + " -> " + oClass.getId());
            ref.setOntologyId(oClass.getId());
        }
    }

    private void registra() {
        this.editionManager.saveEdition(this.edition, false, null, null);
    }

    private void caricaOntologia() {
        this.ontology = this.editionManager.getVariantsOntology();
    }

    private void caricaEdizione() {
        this.edition = this.editionManager.loadEdition(this.editionFile);
    }
}

