/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.utils;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.gui.drawings.DraftExportDirectorFactory;
import org.homelinux.elabor.scriptorium.services.EditionManager;

public class OntologyNameFix {
    private EditionManager editionManager = EditionManager.getInstance();
    private Edition edition;
    private File editionFile;
    private Ontology ontology;

    public static void main(String[] args) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (fileChooser.showOpenDialog(null) == 0) {
                File editionFile = fileChooser.getSelectedFile();
                OntologyNameFix onf = new OntologyNameFix(editionFile);
                onf.fix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OntologyNameFix(File editionFile) {
        this.editionFile = editionFile;
    }

    public void fix() {
        this.caricaEdizione();
        this.caricaOntologia();
        this.ricercaEModifica();
        this.registra();
    }

    private void ricercaEModifica() {
        this.ricercaEModificaTesto();
        this.ricercaEModificaMetadati();
    }

    private void ricercaEModificaTesto() {
        Content content = this.edition.getContent();
        List<Name> names = content.getNames();
        for (Name name : names) {
            List<OntologyReference> oRefs = name.getOntologyReferences();
            for (OntologyReference oRef : oRefs) {
                if (oRef == null) continue;
                this.fixOR(oRef);
            }
        }
        System.out.println("Ricerca e modifica completata dell'ontologia dei nomi nel corpo del testo");
    }

    private void ricercaEModificaMetadati() {
        OntologyReference receiver;
        Header header = this.edition.getHeader();
        OntologyReference author = (OntologyReference)header.getAuthor();
        if (author != null) {
            this.fixOR(author);
        }
        if ((receiver = (OntologyReference)header.getReceiver()) != null) {
            this.fixOR(receiver);
        }
        System.out.println("Ricerca e modifica completata dell'ontologia dei nomi tra i metadati");
    }

    private void fixOR(OntologyReference ref) {
        OntologyClass oClass = this.ontology.getOntologyClassByComment(ref.getOntologyId());
        if (oClass == null) {
            System.out.println("commento non trovato: " + ref.getOntologyId());
        } else {
            System.out.println(String.valueOf(ref.getOntologyId()) + " -> " + oClass.getId());
            ref.setOntologyId(oClass.getId());
        }
    }

    private void registra() {
        this.editionManager.saveEdition(this.edition, false, null, new DraftExportDirectorFactory());
    }

    private void caricaOntologia() {
        this.ontology = this.editionManager.getNamesOntology();
    }

    private void caricaEdizione() {
        this.edition = this.editionManager.loadEdition(this.editionFile);
    }
}

