/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OntologyFix {
    private Document document;
    private File ontologyFile;

    public static void main(String[] args) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (fileChooser.showOpenDialog(null) == 0) {
                File ontologyFile = fileChooser.getSelectedFile();
                OntologyFix of = new OntologyFix(ontologyFile);
                of.fix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OntologyFix(File ontologyFile) throws ParserConfigurationException, SAXException, IOException {
        this.ontologyFile = ontologyFile;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setValidating(false);
        DocumentBuilder builder = docFactory.newDocumentBuilder();
        this.document = builder.parse(ontologyFile);
    }

    public void fix() throws FileNotFoundException, TransformerException {
        System.out.println("begin");
        int n = 0;
        Node child = this.document.getDocumentElement().getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                Element element = (Element)child;
                String classId = element.getAttribute("rdf:ID");
                String classComment = OntologyFix.getClassComment(element);
                if (classId != null && classId.length() > 0) {
                    ++n;
                    System.out.println(String.valueOf(classId) + " : " + classComment);
                    if (classComment.length() == 0) {
                        this.setClassComment(element, classId);
                        OntologyFix.setClassId(element, String.valueOf(n));
                        System.out.println(String.valueOf(element.getAttribute("rdf:ID")) + " : " + OntologyFix.getClassComment(element));
                    }
                }
            }
            child = child.getNextSibling();
        }
        System.out.println("saving");
        this.saveDOM();
        System.out.println("fixed");
    }

    private void saveDOM() throws FileNotFoundException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(this.document);
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintStream out = new PrintStream(this.ontologyFile);){
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void setClassId(Element element, String id) {
        element.setAttribute("rdf:ID", id);
    }

    private void setClassComment(Element element, String comment) {
        Element child = this.document.createElement("rdfs:comment");
        child.setTextContent(comment);
        element.appendChild(child);
    }

    private static String getClassComment(Element element) {
        String comment = "";
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("rdfs:comment")) {
                comment = String.valueOf(comment) + ((Element)child).getTextContent();
            }
            child = child.getNextSibling();
        }
        return comment;
    }
}

