/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.services;

import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.Style;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.ListItem;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Quadratus;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.Rectangulus;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NullEditionVisitor;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;

public class StyledDocumentEditionVisitor
extends NullEditionVisitor {
    private ScriptoriumStyledDocument styledDocument;
    private Stack<AttributeSet> styles;
    private Style text_style;

    public void setStyledDocument(ScriptoriumStyledDocument styledDocument) {
        this.styledDocument = styledDocument;
        this.text_style = this.styledDocument.getStyle("text");
        this.styles = new Stack();
        this.styles.push(this.text_style);
    }

    private void visitComposite(EditionComponent<?> component) {
        for (EditionComponent<?> child : component.getChildren()) {
            child.accept(this);
        }
    }

    private void defaultVisit(EditionComponent<?> component) {
        if (component != null) {
            String elementName = component.getElementName();
            Style style = this.styledDocument.getStyle(elementName);
            this.styles.push(style);
            this.visitComposite(component);
            this.styles.pop();
        }
    }

    @Override
    public void visit(Edition edition) {
        edition.getContent().accept(this);
    }

    @Override
    public void visit(Content content) {
        this.visitComposite(content);
    }

    @Override
    public void visit(Variant variant) {
        VariantItem variant_item = variant.getBasicTextVariantItem();
        if (variant_item != null) {
            variant_item.accept(this);
        }
    }

    @Override
    public void visit(VariantItem variant_item) {
        Reading reading = variant_item.getReading();
        if (reading != null) {
            reading.accept(this);
        }
    }

    @Override
    public void visit(Reading reading) {
        String left_delimiter = "|";
        String right_delimiter = "|";
        this.visitDelimitedComponent(reading, left_delimiter, right_delimiter);
    }

    @Override
    public void visit(Expunctio expunctio) {
        String left_delimiter = "[";
        String right_delimiter = "]";
        this.visitDelimitedComponent(expunctio, left_delimiter, right_delimiter);
    }

    @Override
    public void visit(Crux crux) {
        String left_delimiter = "\u2020";
        String right_delimiter = "\u2020";
        this.visitDelimitedComponent(crux, left_delimiter, right_delimiter);
    }

    @Override
    public void visit(Integratio integratio) {
        this.visitNonValuedToken(integratio);
    }

    @Override
    public void visit(Annotation annotation) {
        this.visitNonValuedToken(annotation);
    }

    @Override
    public void visit(ListItem list_item) {
        String left_delimiter = "\u00b0\t";
        String right_delimiter = "";
        this.visitDelimitedComponent(list_item, left_delimiter, right_delimiter);
    }

    private void visitDelimitedComponent(EditionComponent<?> component, String left_delimiter, String right_delimiter) {
        this.styledDocument.appendString(left_delimiter, this.text_style);
        this.defaultVisit(component);
        this.styledDocument.appendString(right_delimiter, this.text_style);
    }

    @Override
    public void visit(Name name) {
        this.defaultVisit(name);
    }

    @Override
    public void visit(DateToken date) {
        this.defaultVisit(date);
    }

    @Override
    public void visit(Place place) {
        this.defaultVisit(place);
    }

    @Override
    public void visit(Tongue tongue) {
        this.defaultVisit(tongue);
    }

    @Override
    public void visit(MathConcept mathConcept) {
        this.defaultVisit(mathConcept);
    }

    @Override
    public void visit(Enunciatio enunciatio) {
        this.defaultVisit(enunciatio);
    }

    @Override
    public void visit(Formula formula) {
        this.defaultVisit(formula);
    }

    @Override
    public void visit(Citation citation) {
        this.defaultVisit(citation);
    }

    @Override
    public void visit(Text text) {
        this.styledDocument.appendString(text.getValue(), this.styles.peek());
    }

    private void visitNonValuedToken(EditionComponent<?> token) {
        String elementName = token.getElementName();
        Style style = this.styledDocument.getStyle(elementName);
        this.styledDocument.appendString("*", style);
    }

    @Override
    public void visit(Drawing drawing) {
        this.visitNonValuedToken(drawing);
    }

    @Override
    public void visit(Unit unit) {
        this.visitNonValuedToken(unit);
    }

    @Override
    public void visit(TextPart part) {
        this.visitNonValuedToken(part);
    }

    @Override
    public void visit(Folium folium) {
        this.visitNonValuedToken(folium);
    }

    @Override
    public void visit(Quadratus quadratus) {
        this.visitNonValuedToken(quadratus);
    }

    @Override
    public void visit(Rectangulus rectangulus) {
        this.visitNonValuedToken(rectangulus);
    }

    @Override
    public void visit(Comment comment) {
        this.visitNonValuedToken(comment);
    }

    @Override
    public void visit(Work work) {
        this.defaultVisit(work);
    }

    @Override
    public void visit(Image image) {
        this.visitNonValuedToken(image);
    }

    @Override
    public void visit(ComputeAction action) {
        this.defaultVisit(action);
    }

    @Override
    public void visit(StraightLineAction straightLineAction) {
    }

    @Override
    public void visit(StraightLineDirectionAction straightLineDirectionAction) {
    }
}

