/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.ConicActionListener;
import org.homelinux.elabor.scriptorium.ndraft.LimitPointsActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.SingleButtonHandler;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.ui.UITools;

public class TangentActionDialog
extends LimitPointsActionDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private final List<ComputeAction> drawingActions;
    private SingleButtonHandler handler;
    private ComputeAction selectedAction;

    public TangentActionDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints, List<ComputeAction> drawingActions) {
        this.points = points;
        this.drawingActions = drawingActions;
        this.setModal(false);
        this.frame = frame;
        this.setSize(600, 600);
        this.setTitle("choose tangent properties");
        this.setDefaultCloseOperation(2);
        this.handler = new SingleButtonHandler();
        ChoosePointsArea pointsArea = new ChoosePointsArea(this.handler, "point", this.points, true, false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        UITools.addComponent(contentPane, pointsArea, 0, 0, 1, 1, 100, 100, 1, 2);
        JPanel conicsArea = this.buildConicsArea(drawingPoints);
        UITools.addComponent(this, conicsArea, 0, 1, 1, 1, 100, 100, 1, 2);
        JScrollPane limitsArea = this.buildLimitsPanel(drawingPoints);
        UITools.addComponent(contentPane, limitsArea, 0, 2, 1, 1, 100, 100, 1, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 3, 1, 1, 100, 10, 0, 2);
    }

    private JPanel buildConicsArea(Iterable<ScriptoriumPoint> drawingPoints) {
        JPanel equalToArea = new JPanel(new GridBagLayout());
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, "tangent to");
        equalToArea.setBorder(titledBorder);
        JPanel pointChoiche = new JPanel(new GridBagLayout());
        Highlighter highlighter = new Highlighter(OntologyInitialiser.NULL);
        highlighter.setDrawingPoints(drawingPoints);
        highlighter.setDrawingActions(this.drawingActions);
        ButtonGroup group = new ButtonGroup();
        KeyExtractor<ComputeAction, ComputeAction> extractor = action -> action.isConic() ? action : null;
        List<ComputeAction> curveActions = StructuresHelper.buildList(this.drawingActions, extractor);
        int position = 0;
        for (ComputeAction action2 : curveActions) {
            highlighter.visit(action2);
            String text = highlighter.getText();
            JRadioButton button = new JRadioButton(text);
            group.add(button);
            ConicActionListener listener = new ConicActionListener(action2, this);
            button.addActionListener(listener);
            UITools.addComponent(pointChoiche, button, 1, position, 1, 1, 100, 1, 2, 2);
            ++position;
        }
        JScrollPane scrollPane = new JScrollPane(pointChoiche);
        UITools.addComponent(equalToArea, scrollPane, 1, 0, 1, 1, 100, 100, 1, 2);
        return equalToArea;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ScriptoriumPoint fixedPoint = this.handler.getSelectedPoint();
        if (fixedPoint == null) {
            JOptionPane.showMessageDialog(null, "you should select the fixed point");
        } else if (this.selectedAction == null) {
            JOptionPane.showMessageDialog(null, "you should select a curve");
        } else if (ShapeAdapter.findConicAction(fixedPoint, this.drawingActions) == null) {
            JOptionPane.showMessageDialog(null, "you should select a point belonging to the curve");
        } else if (this.limitPoints.size() != 2) {
            JOptionPane.showMessageDialog(null, "exactly two limit points should be selected");
        } else {
            ScriptoriumPoint startPoint = (ScriptoriumPoint)this.limitPoints.get(0);
            ScriptoriumPoint endPoint = (ScriptoriumPoint)this.limitPoints.get(1);
            this.frame.addTangentAction(fixedPoint, this.points, this.selectedAction, startPoint, endPoint);
            this.dispose();
        }
    }

    public void setAction(ComputeAction action) {
        this.selectedAction = action;
    }
}

