/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.ndraft.ComputeActionListener;
import org.homelinux.elabor.scriptorium.ndraft.LimitPointsActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.ui.UITools;

public class SnapActionDialog
extends LimitPointsActionDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private ComputeAction selectedAction;

    public SnapActionDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ComputeAction> actions, Iterable<ScriptoriumPoint> drawingPoints) {
        this.setModal(false);
        this.frame = frame;
        this.points = points;
        this.setSize(600, 300);
        this.setTitle("choose curve");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JPanel chooseActionArea = this.buildChooseActionArea(actions, drawingPoints);
        UITools.addComponent(contentPane, chooseActionArea, 0, 4, 1, 1, 100, 10, 1, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 5, 1, 1, 100, 0, 3, 5);
        this.selectedAction = null;
    }

    private JPanel buildChooseActionArea(Iterable<ComputeAction> drawingActions, Iterable<ScriptoriumPoint> drawingPoints) {
        Highlighter highlighter = new Highlighter(OntologyInitialiser.NULL);
        highlighter.setDrawingPoints(drawingPoints);
        highlighter.setDrawingActions(drawingActions);
        JPanel chooseActionArea = new JPanel();
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, "curves");
        chooseActionArea.setBorder(titledBorder);
        chooseActionArea.setLayout(new GridBagLayout());
        JPanel actionsPane = new JPanel();
        actionsPane.setLayout(new GridBagLayout());
        KeyExtractor<ComputeAction, ComputeAction> extractor = action -> action.isTarget() ? action : null;
        List<ComputeAction> targetActions = StructuresHelper.buildList(drawingActions, extractor);
        int row = 0;
        ButtonGroup group = new ButtonGroup();
        for (ComputeAction action2 : targetActions) {
            action2.accept(highlighter);
            String text = highlighter.getText();
            JRadioButton button = new JRadioButton(text);
            group.add(button);
            ComputeActionListener actionListener = new ComputeActionListener(this, action2);
            button.addItemListener(actionListener);
            UITools.addComponent(actionsPane, button, 0, row, 1, 1, 10, 10, 2, 2);
            ++row;
        }
        JScrollPane scrollPane = new JScrollPane(actionsPane);
        UITools.addComponent(chooseActionArea, scrollPane, 0, 0, 1, 1, 100, 1000, 1, 2);
        return chooseActionArea;
    }

    public void setSelectedAction(ComputeAction selectedAction) {
        this.selectedAction = selectedAction;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            if (this.selectedAction == null) {
                throw new DataNotFoundException("you should select an action");
            }
            this.frame.addSnapAction(this.points, this.selectedAction);
            this.dispose();
        }
        catch (DataNotFoundException exc) {
            JOptionPane.showMessageDialog(null, exc.getMessage());
        }
    }
}

