/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.ActionsHelper;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.MultipleButtonHandler;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.ProjectionSetter;
import org.homelinux.elabor.scriptorium.ndraft.ProjectionsArea;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjection;
import org.homelinux.elabor.ui.UITools;

public class PointsLineDialog
extends JDialog
implements ProjectionSetter,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final Map<ScriptoriumPoint, ComputeAction> pointsAction;
    private final List<ScriptoriumPoint> points;
    private MultipleButtonHandler handler;
    private DraftProjection projection;

    public PointsLineDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ComputeAction> actions, Iterable<ScriptoriumPoint> drawingPoints) {
        this.setModal(false);
        this.frame = frame;
        this.pointsAction = ActionsHelper.buildPointsAction(points);
        this.setSize(1000, 700);
        this.setTitle("choose some fixed points line properties");
        this.setDefaultCloseOperation(2);
        this.points = points;
        this.handler = new MultipleButtonHandler(0);
        ChoosePointsArea pointsArea = new ChoosePointsArea(this.handler, "points", this.points, this.pointsAction, actions, drawingPoints, true, false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        UITools.addComponent(contentPane, pointsArea, 0, 0, 1, 1, 100, 100, 1, 2);
        ProjectionsArea projectionsArea = new ProjectionsArea(this);
        UITools.addComponent(contentPane, projectionsArea, 0, 1, 1, 1, 100, 10, 2, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 2, 1, 1, 100, 10, 0, 2);
        this.projection = null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        List<ScriptoriumPoint> fixedPoints = this.handler.getSelectedPoints();
        if (fixedPoints.size() >= 2 && this.projection != null) {
            this.dispose();
            this.frame.addPointsLine(this.pointsAction, fixedPoints, this.projection);
        } else {
            JOptionPane.showMessageDialog(null, "you should select at least 2 points and the projection type");
        }
    }

    @Override
    public void setProjection(DraftProjection projection) {
        this.projection = projection;
    }
}

