/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.BasicLabeledPoint;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.LabeledPoint;
import org.homelinux.elabor.scriptorium.ndraft.LimitPointsActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.MultipleButtonHandler;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.SingleButtonHandler;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.ui.UITools;

public class HyperbolaActionDialog
extends LimitPointsActionDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private final JCheckBox asymptotesCheckBox;
    private SingleButtonHandler centerHandler;
    private MultipleButtonHandler fixedHandler;
    private SingleButtonHandler passingByHandler;
    private int numBranches;
    private int centerIndex;

    public HyperbolaActionDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints) {
        ChoosePointsArea centerArea;
        this.setModal(false);
        this.frame = frame;
        this.points = points;
        this.setSize(500, 600);
        this.setTitle("choose hyperbola parameters");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.asymptotesCheckBox = new JCheckBox("asymptotes");
        JPanel optionsArea = this.buildOptionsArea();
        UITools.addComponent(contentPane, optionsArea, 0, 0, 1, 1, 0, 0, 2, 2);
        if (points.size() == 2) {
            this.centerHandler = new SingleButtonHandler();
            centerArea = new ChoosePointsArea(this.centerHandler, "center", this.points, false, true);
        } else {
            List<Point2D> points2D = GeometricHelper.extractPoint2D(points);
            this.centerIndex = GeometricHelper.findCenter(points2D);
            ScriptoriumPoint center = this.points.get(this.centerIndex);
            KeyExtractor<LabeledPoint, ScriptoriumPoint> extractor = point -> new BasicLabeledPoint((ScriptoriumPoint)point, point.equals(center) ? "center" : "vertex");
            List<LabeledPoint> labeledPoints = StructuresHelper.buildList(points, extractor);
            this.fixedHandler = new MultipleButtonHandler(2);
            centerArea = new ChoosePointsArea(this.fixedHandler, "fixed points", labeledPoints, false, false);
        }
        UITools.addComponent(contentPane, centerArea, 0, 1, 1, 1, 100, 0, 1, 2);
        this.passingByHandler = new SingleButtonHandler();
        ChoosePointsArea pointsArea = new ChoosePointsArea(this.passingByHandler, "passing by", drawingPoints, true, false);
        UITools.addComponent(contentPane, pointsArea, 0, 3, 1, 1, 100, 10, 1, 2);
        JScrollPane limitPointsArea = this.buildLimitsPanel(drawingPoints);
        UITools.addComponent(contentPane, limitPointsArea, 0, 4, 1, 1, 100, 10, 1, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 5, 1, 1, 100, 0, 3, 5);
    }

    private JPanel buildOptionsArea() {
        JPanel optionsArea = new JPanel();
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, "branches");
        optionsArea.setBorder(titledBorder);
        optionsArea.setLayout(new GridBagLayout());
        JRadioButton oneBranchButton = new JRadioButton("1");
        oneBranchButton.addItemListener(this);
        JRadioButton twoBranchesButton = new JRadioButton("2");
        twoBranchesButton.addItemListener(this);
        JRadioButton fourBranchesButton = new JRadioButton("4");
        fourBranchesButton.addItemListener(this);
        ButtonGroup branchesGroup = new ButtonGroup();
        branchesGroup.add(oneBranchButton);
        branchesGroup.add(twoBranchesButton);
        branchesGroup.add(twoBranchesButton);
        oneBranchButton.setSelected(true);
        UITools.addComponent(optionsArea, oneBranchButton, 1, 0, 1, 1, 0, 0, 0, 2);
        UITools.addComponent(optionsArea, twoBranchesButton, 2, 0, 1, 1, 0, 0, 0, 2);
        UITools.addComponent(optionsArea, fourBranchesButton, 3, 0, 1, 1, 0, 0, 0, 2);
        UITools.addComponent(optionsArea, this.asymptotesCheckBox, 4, 0, 1, 1, 0, 0, 0, 2);
        return optionsArea;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            List<ScriptoriumPoint> fixedPoints;
            ScriptoriumPoint vertex2;
            ScriptoriumPoint vertex1;
            ScriptoriumPoint center;
            ScriptoriumPoint passingBy = this.passingByHandler.getSelectedPoint();
            if (passingBy == null) {
                throw new DataNotFoundException("you should select a passing by point");
            }
            if (this.points.size() == 2) {
                center = this.centerHandler.getSelectedPoint();
                if (center == null) {
                    vertex1 = this.points.get(0);
                    vertex2 = this.points.get(1);
                } else {
                    vertex1 = this.getVertex(center);
                    vertex2 = null;
                }
                fixedPoints = new ArrayList<ScriptoriumPoint>();
            } else {
                center = this.points.get(this.centerIndex);
                fixedPoints = this.fixedHandler.getSelectedPoints();
                if (fixedPoints.isEmpty()) {
                    throw new DataNotFoundException("you should select at least one fixed point");
                }
                if (fixedPoints.size() == 1) {
                    ScriptoriumPoint fixedPoint = fixedPoints.get(0);
                    if (!fixedPoint.equals(center)) throw new DataNotFoundException("you should select the center");
                    List<ScriptoriumPoint> vertices = this.getVertices(center);
                    vertex1 = vertices.get(0);
                    vertex2 = vertices.get(1);
                } else {
                    List<ScriptoriumPoint> vertices = this.getVertices(center);
                    vertex1 = vertices.get(0);
                    vertex2 = vertices.get(1);
                }
            }
            boolean asymptotes = this.asymptotesCheckBox.isSelected();
            if (this.limitPoints.size() != 2) {
                throw new DataNotFoundException(null, "exactly two limit points should be selected");
            }
            ScriptoriumPoint startPoint = (ScriptoriumPoint)this.limitPoints.get(0);
            ScriptoriumPoint endPoint = (ScriptoriumPoint)this.limitPoints.get(1);
            this.frame.addHyperbolaAction(this.numBranches, asymptotes, vertex1, vertex2, center, passingBy, fixedPoints, startPoint, endPoint);
            this.dispose();
            return;
        }
        catch (DataNotFoundException exc) {
            JOptionPane.showMessageDialog(null, exc.getMessage());
        }
    }

    private List<ScriptoriumPoint> getVertices(ScriptoriumPoint center) {
        KeyExtractor<ScriptoriumPoint, ScriptoriumPoint> extractor = point -> point.equals(center) ? null : point;
        return StructuresHelper.buildList(this.points, extractor);
    }

    private ScriptoriumPoint getVertex(ScriptoriumPoint center) {
        return this.getVertices(center).get(0);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        JRadioButton button = (JRadioButton)event.getSource();
        if (button.isSelected()) {
            this.numBranches = Integer.parseInt(button.getText());
        }
    }
}

