/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.BasicLabeledPoint;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.LabeledPoint;
import org.homelinux.elabor.scriptorium.ndraft.MultipleButtonHandler;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.SingleButtonHandler;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.ui.UITools;

public class EllipseActionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private SingleButtonHandler centerHandler;
    private MultipleButtonHandler fixedHandler;
    private SingleButtonHandler passingByHandler;
    private int centerIndex;

    public EllipseActionDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints) {
        ChoosePointsArea centerArea;
        this.setModal(false);
        this.frame = frame;
        this.points = points;
        this.setSize(500, 600);
        this.setTitle("choose ellipse parameters");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        if (points.size() == 2) {
            this.centerHandler = new SingleButtonHandler();
            centerArea = new ChoosePointsArea(this.centerHandler, "center", this.points, false, true);
        } else {
            List<Point2D> points2D = GeometricHelper.extractPoint2D(points);
            this.centerIndex = GeometricHelper.findCenter(points2D);
            ScriptoriumPoint center = this.points.get(this.centerIndex);
            KeyExtractor<LabeledPoint, ScriptoriumPoint> extractor = point -> new BasicLabeledPoint((ScriptoriumPoint)point, point.equals(center) ? "center" : "vertex");
            List<LabeledPoint> labeledPoints = StructuresHelper.buildList(points, extractor);
            this.fixedHandler = new MultipleButtonHandler(2);
            centerArea = new ChoosePointsArea(this.fixedHandler, "fixed points", labeledPoints, true, false);
        }
        UITools.addComponent(contentPane, centerArea, 0, 0, 1, 1, 100, 0, 1, 2);
        this.passingByHandler = new SingleButtonHandler();
        ChoosePointsArea pointsArea = new ChoosePointsArea(this.passingByHandler, "passing by", drawingPoints, true, false);
        UITools.addComponent(contentPane, pointsArea, 0, 3, 1, 1, 100, 10, 1, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 4, 1, 1, 100, 0, 3, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            List<ScriptoriumPoint> fixedPoints;
            ScriptoriumPoint vertex2;
            ScriptoriumPoint vertex1;
            ScriptoriumPoint center;
            ScriptoriumPoint passingBy = this.passingByHandler.getSelectedPoint();
            if (passingBy == null) {
                throw new DataNotFoundException("you should select a passing by point");
            }
            if (this.points.size() == 2) {
                center = this.centerHandler.getSelectedPoint();
                if (center == null) {
                    vertex1 = this.points.get(0);
                    vertex2 = this.points.get(1);
                } else {
                    vertex1 = this.getVertex(center);
                    vertex2 = null;
                }
                fixedPoints = new ArrayList<ScriptoriumPoint>();
            } else {
                center = this.points.get(this.centerIndex);
                fixedPoints = this.fixedHandler.getSelectedPoints();
                if (fixedPoints.isEmpty()) {
                    throw new DataNotFoundException("you should select at least one fixed point");
                }
                if (fixedPoints.size() == 1) {
                    ScriptoriumPoint fixedPoint = fixedPoints.get(0);
                    if (!fixedPoint.equals(center)) throw new DataNotFoundException("you should select the center");
                    List<ScriptoriumPoint> vertices = this.getVertices(center);
                    vertex1 = vertices.get(0);
                    vertex2 = vertices.get(1);
                } else {
                    List<ScriptoriumPoint> vertices = this.getVertices(center);
                    vertex1 = vertices.get(0);
                    vertex2 = vertices.get(1);
                }
            }
            this.frame.addEclipseAction(vertex1, vertex2, center, passingBy, fixedPoints);
            this.dispose();
            return;
        }
        catch (DataNotFoundException exc) {
            JOptionPane.showMessageDialog(null, exc.getMessage());
        }
    }

    private List<ScriptoriumPoint> getVertices(ScriptoriumPoint center) {
        KeyExtractor<ScriptoriumPoint, ScriptoriumPoint> extractor = point -> point.equals(center) ? null : point;
        return StructuresHelper.buildList(this.points, extractor);
    }

    private ScriptoriumPoint getVertex(ScriptoriumPoint center) {
        return this.getVertices(center).get(0);
    }
}

