/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.variants;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.ReadingReference;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class DescriptionItemPanel
extends ScriptoriumPanel<DescriptionItem>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String[] desItemTypes;
    private DefaultGenericSelectionModel<DescriptionItem> descriptionItems;
    private int index;
    private Description description;
    private DescriptionItem descriptionItem;
    private Ontology ontology;
    private JComboBox<String> desItemTypesMenu;
    private JPanel fieldsPanel;
    private JPanel ontRefFieldsPanel;
    private JPanel readingFieldsPanel;
    private JComboBox<OntologyClass> ontology_menu;
    private JTextField ontArgField;
    private JTextField readingField;
    private DefaultGenericSelectionModel<OntologyClass> ontologyClasses;

    public DescriptionItemPanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        this.ontology = EditionManager.getInstance().getVariantsOntology();
        List<OntologyClass> classes = this.ontology.getClasses();
        this.ontologyClasses = new DefaultGenericSelectionModel<OntologyClass>(classes);
        this.ontology_menu = new JComboBox<OntologyClass>(this.ontologyClasses);
        this.ontArgField = new JTextField();
        this.ontArgField.setFont(this.ontArgField.getFont().deriveFont(fontSize));
        this.ontArgField.setBackground(editableBgColor);
        this.ontArgField.setEditable(true);
        this.ontRefFieldsPanel = new JPanel();
        this.ontRefFieldsPanel.setLayout(new GridBagLayout());
        UITools.addComponent(this.ontRefFieldsPanel, this.ontology_menu, 0, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this.ontRefFieldsPanel, this.ontArgField, 1, 0, 1, 1, 100, 1, 2, 2);
        this.readingFieldsPanel = new JPanel();
        this.readingFieldsPanel.setLayout(new GridBagLayout());
        this.readingField = new JTextField();
        this.readingField.setFont(this.readingField.getFont().deriveFont(fontSize));
        this.readingField.setBackground(editableBgColor);
        this.readingField.setEditable(true);
        this.readingFieldsPanel = new JPanel();
        this.readingFieldsPanel.setLayout(new GridBagLayout());
        UITools.addComponent(this.readingFieldsPanel, this.readingField, 0, 0, 1, 1, 100, 1, 2, 2);
        this.desItemTypesMenu = new JComboBox<String>(this.desItemTypes);
        this.fieldsPanel = null;
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.desItemTypesMenu, 0, 0, 1, 1, 1, 1, 0, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.desItemTypes = new String[3];
        this.desItemTypes[0] = catalog.translate("reading");
        this.desItemTypes[1] = catalog.translate("reading_reference");
        this.desItemTypes[2] = catalog.translate("ontology_reference");
    }

    public void setup(Description description, DefaultGenericSelectionModel<DescriptionItem> description_items, int index) {
        this.description = description;
        this.descriptionItems = description_items;
        this.index = index;
        if (index >= 0) {
            this.descriptionItem = this.descriptionItems.get(this.index).makeCopy(new DescriptionItem());
        } else {
            this.descriptionItem = new DescriptionItem(this.description);
            this.descriptionItem.setAsOntologyReference(new OntologyReference(this.descriptionItem));
        }
        this.setup();
    }

    private void setup() {
        ReadingReference reading_reference;
        Reading reading;
        OntologyReference reference;
        this.desItemTypesMenu.removeActionListener(this);
        if (this.fieldsPanel != null) {
            this.remove(this.fieldsPanel);
            this.fieldsPanel = null;
        }
        if ((reference = this.descriptionItem.getOntologyReference()) != null) {
            this.desItemTypesMenu.setSelectedIndex(2);
            OntologyClass selected = this.ontology.getOntologyClass(reference);
            if (selected == null && this.ontologyClasses.getSize() > 0) {
                this.ontology_menu.setSelectedIndex(0);
            } else {
                int selectedIndex = this.ontologyClasses.indexOf(selected);
                this.ontology_menu.setSelectedIndex(selectedIndex);
            }
            this.ontArgField.setText(reference.getArgument());
            this.fieldsPanel = this.ontRefFieldsPanel;
        }
        if ((reading = this.descriptionItem.getReading()) != null) {
            this.desItemTypesMenu.setSelectedIndex(0);
            this.readingField.setText(reading.toString());
            this.fieldsPanel = this.readingFieldsPanel;
        }
        if ((reading_reference = this.descriptionItem.getReadingReference()) != null) {
            this.desItemTypesMenu.setSelectedIndex(1);
            this.fieldsPanel = null;
        }
        if (this.fieldsPanel != null) {
            UITools.addComponent(this, this.fieldsPanel, 0, 1, 1, 1, 100, 100, 1, 2);
        }
        this.desItemTypesMenu.addActionListener(this);
        this.validate();
        this.repaint();
    }

    @Override
    public boolean okAction() {
        switch (this.descriptionItem.getType()) {
            case READING_TYPE: {
                Reading reading = this.descriptionItem.getReading();
                if (reading == null) break;
                reading.setValue(this.readingField.getText());
                break;
            }
            case READING_REFERENCE_TYPE: {
                break;
            }
            case ONTOLOGY_REFERENCE_TYPE: {
                OntologyReference ontology_reference = this.descriptionItem.getOntologyReference();
                if (ontology_reference == null) break;
                ontology_reference.setOntologyId(this.ontologyClasses.get(this.ontology_menu.getSelectedIndex()).getId());
                ontology_reference.setArgument(this.ontArgField.getText());
            }
        }
        if (this.index >= 0) {
            this.description.replaceItem(this.descriptionItems.get(this.index), this.descriptionItem);
            this.descriptionItems.set(this.index, this.descriptionItem);
        } else {
            this.description.addItem(this.descriptionItem);
            this.descriptionItems.append(this.descriptionItem);
        }
        return super.okAction();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.desItemTypesMenu) {
            switch (DescriptionItem.DescriptionItemType.values()[this.desItemTypesMenu.getSelectedIndex()]) {
                case READING_TYPE: {
                    if (this.descriptionItem.getReading() != null) break;
                    this.descriptionItem.setAsReading(new Reading(this.descriptionItem));
                    break;
                }
                case READING_REFERENCE_TYPE: {
                    if (this.descriptionItem.getReadingReference() != null) break;
                    this.descriptionItem.setAsReadingReference(new ReadingReference(this.descriptionItem));
                    break;
                }
                case ONTOLOGY_REFERENCE_TYPE: {
                    if (this.descriptionItem.getOntologyReference() != null) break;
                    this.descriptionItem.setAsOntologyReference(new OntologyReference(this.descriptionItem));
                }
            }
            this.setup();
        }
    }
}

