/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.units;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.WindowsFactory;
import org.homelinux.elabor.scriptorium.gui.units.UnitPanel;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class UnitsPanel
extends OldScriptoriumListArea<Unit> {
    private static final long serialVersionUID = 1L;
    private EditionComponentFrame<Unit, UnitPanel> unitFrame;

    public UnitsPanel() {
        super(false, true, true);
        this.setBorder(new LineBorder(Color.black));
    }

    @Override
    public void setup(ScriptoriumDirector director, Unit unit) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Unit> units = content.getUnits();
        super.setup(director, units, unit);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, Unit unit) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        ScriptoriumDirector director = this.getDirector();
        director.downgradeComponent(unit);
    }

    @Override
    public void editAction(int index, Unit unit) {
        this.openUnitFrame(unit);
    }

    @Override
    public boolean closing() {
        if (this.unitFrame != null) {
            this.unitFrame.dispose();
        }
        return super.closing();
    }

    private void openUnitFrame(Unit unit) {
        if (this.unitFrame == null) {
            this.unitFrame = WindowsFactory.getUnitFrame();
        }
        ScriptoriumDirector director = this.getDirector();
        this.unitFrame.setup(director, unit);
    }
}

