/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.places;

import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.OntologyRefererPanel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class PlacePanel
extends OntologyRefererPanel<Place> {
    private static final long serialVersionUID = 1L;
    private JLabel placeLabel;
    private final Highlighter highlighter;

    public PlacePanel() {
        JScrollPane scrollPane = this.createScrollPane(0);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        this.placeLabel = UITools.setupLabel("", fontSize);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.placeLabel, 0, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, scrollPane, 0, 1, 1, 1, 100, 100, 1, 2);
        EditionManager editionManager = EditionManager.getInstance();
        Ontology ontology = editionManager.getPlacesOntology();
        this.setOntology(ontology);
        this.highlighter = new Highlighter(OntologyInitialiser.PLACES);
    }

    public void setup(GenericSelectionModel<Place> places, int index) {
        Place place = (Place)places.get(index);
        this.setReferer(place);
        this.highlighter.visit(place);
        String text = this.highlighter.getText();
        this.placeLabel.setText(text);
        this.selectIndices();
    }
}

