/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.metadata;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.metadata.MetadataPanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class MetadataSummaryPanel
extends ScriptoriumPanel<Header> {
    public static final long serialVersionUID = 1L;
    private Header header;
    private JTextField titleField;
    private JTextField authorField;
    private JTextField receiverField;
    private JTextField dateField;
    private String titleString;
    private String authorString;
    private String receiverString;
    private String dateLabelString;
    private Color textFieldsProtectedBgColor;
    private Ontology ontology;
    private static DateFormat DATE_FORMAT;

    public MetadataSummaryPanel(Edition edition, Ontology ontology) {
        this.initLocale();
        this.header = edition.getHeader();
        JLabel titleLabel = new JLabel(this.titleString, 4);
        JLabel authorLabel = new JLabel(this.authorString, 4);
        JLabel receiverLabel = new JLabel(this.receiverString, 4);
        JLabel dateLabel = new JLabel(this.dateLabelString, 4);
        this.titleField = new JTextField();
        this.authorField = new JTextField();
        this.receiverField = new JTextField();
        this.dateField = new JTextField();
        this.titleField.setEditable(false);
        this.titleField.setBackground(this.textFieldsProtectedBgColor);
        this.authorField.setEditable(false);
        this.authorField.setBackground(this.textFieldsProtectedBgColor);
        this.receiverField.setEditable(false);
        this.receiverField.setBackground(this.textFieldsProtectedBgColor);
        this.dateField.setEditable(false);
        this.dateField.setBackground(this.textFieldsProtectedBgColor);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, titleLabel, 0, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.titleField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, authorLabel, 2, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.authorField, 3, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, receiverLabel, 4, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.receiverField, 5, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, dateLabel, 6, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.dateField, 7, 0, 1, 1, 10, 1, 2, 2);
        this.ontology = ontology;
    }

    private void initLocale() {
        Locale locale = Locale.getDefault();
        DATE_FORMAT = DateFormat.getDateInstance(2, locale);
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(MetadataPanel.class.getName(), locale);
        this.titleString = catalog.translate("title");
        this.authorString = catalog.translate("author");
        this.receiverString = catalog.translate("receiver");
        this.dateLabelString = catalog.translate("date");
        Preferences preferences = Preferences.getInstance();
        this.textFieldsProtectedBgColor = preferences.getColor("text_fields_protected_bg_color");
    }

    public void setup() {
        String title = this.header.getTitle();
        OntologyReferenceInterface authorReference = this.header.getAuthor();
        OntologyReferenceInterface receiverReference = this.header.getReceiver();
        OntologyClass author = this.ontology.getOntologyClass(authorReference);
        OntologyClass receiver = this.ontology.getOntologyClass(receiverReference);
        Date date = this.header.getDate();
        String dateString = date == null ? "***" : DATE_FORMAT.format(date);
        this.titleField.setText(title);
        this.authorField.setText(author == null ? "***" : author.toString());
        this.receiverField.setText(receiver == null ? "***" : receiver.toString());
        this.dateField.setText(dateString);
    }
}

