/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.folia;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.WindowsFactory;
import org.homelinux.elabor.scriptorium.gui.folia.FoliumPanel;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class FoliaPanel
extends OldScriptoriumListArea<Folium> {
    private static final long serialVersionUID = 1L;
    private EditionComponentFrame<Folium, FoliumPanel> foliumFrame;

    public FoliaPanel() {
        super(false, true, true);
        this.setBorder(new LineBorder(Color.black));
    }

    @Override
    public void setup(ScriptoriumDirector director, Folium folium) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Folium> folia = content.getFolia();
        super.setup(director, folia, folium);
    }

    private void openFoliumFrame(Folium folium) {
        if (this.foliumFrame == null) {
            this.foliumFrame = WindowsFactory.getFoliumFrame();
        }
        ScriptoriumDirector director = this.getDirector();
        this.foliumFrame.setup(director, folium);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, Folium folium) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        ScriptoriumDirector director = this.getDirector();
        director.downgradeComponent(folium);
    }

    @Override
    public void editAction(int index, Folium folium) {
        this.openFoliumFrame(folium);
    }

    @Override
    public boolean closing() {
        if (this.foliumFrame != null) {
            this.foliumFrame.dispose();
        }
        return super.closing();
    }
}

