/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.transformations;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class DrawingRotationPanel
extends ScriptoriumPanel<Transform> {
    private static final long serialVersionUID = 1L;
    private String rotationString;
    private String xRotationString;
    private String yRotationString;
    private JTextField rotationField;
    private JTextField xRotationField;
    private JTextField yRotationField;
    private DrawingDirector director;

    public DrawingRotationPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel rotation_label = new JLabel(String.valueOf(this.rotationString) + " (\u00b0)", 4);
        this.rotationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel xRotation_label = new JLabel(this.xRotationString, 4);
        this.xRotationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel yRotation_label = new JLabel(this.yRotationString, 4);
        this.yRotationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, rotation_label, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.rotationField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, xRotation_label, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.xRotationField, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, yRotation_label, 0, 2, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.yRotationField, 1, 2, 1, 1, 100, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.rotationString = catalog.translate("rotation");
        this.xRotationString = catalog.translate("xRotation");
        this.yRotationString = catalog.translate("yRotation");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        this.rotationField.setText("0");
        this.xRotationField.setText("0");
        this.yRotationField.setText("0");
    }

    @Override
    public boolean okAction() {
        boolean ok;
        String rotText = this.rotationField.getText();
        DefaultPanel.CheckDoubleField checkRot = this.checkDoubleField(rotText, this.rotationString);
        String xRotText = this.xRotationField.getText();
        DefaultPanel.CheckDoubleField checkXRot = this.checkDoubleField(xRotText, this.xRotationString);
        String yRotText = this.yRotationField.getText();
        DefaultPanel.CheckDoubleField checkYRot = this.checkDoubleField(yRotText, this.yRotationString);
        boolean bl = ok = checkRot.ok && checkXRot.ok && checkYRot.ok;
        if (ok) {
            this.director.executeDrawingRotation(checkRot.value, checkXRot.value, checkYRot.value);
        }
        return ok;
    }
}

