/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.transformations;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.transformations.DrawingInversionButtonListener;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class DrawingInversionPanel
extends ScriptoriumPanel<Transform> {
    private static final long serialVersionUID = 1L;
    private String horizontalAxeLabel;
    private String verticalAxeLabel;
    private String axeCoordinateLabel;
    private String noneAxeChoosedString;
    private JRadioButton horizontalAxeButton;
    private JRadioButton verticalAxeButton;
    private JTextField axeCoordinateField;
    private DrawingDirector director;
    private DrawingInversionButtonListener buttonListener;
    private String commonAxeLabel;

    public DrawingInversionPanel() {
        this.initLocale();
        JLabel commonAxe_label = new JLabel(this.commonAxeLabel, 2);
        JLabel horizontalAxe_label = new JLabel(this.horizontalAxeLabel, 4);
        this.horizontalAxeButton = new JRadioButton();
        JLabel verticalAxe_label = new JLabel(this.verticalAxeLabel, 4);
        this.verticalAxeButton = new JRadioButton();
        JLabel axeCoordinate_label = new JLabel(this.axeCoordinateLabel, 4);
        this.axeCoordinateField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, commonAxe_label, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, horizontalAxe_label, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.horizontalAxeButton, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, verticalAxe_label, 0, 2, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.verticalAxeButton, 1, 2, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, axeCoordinate_label, 0, 3, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.axeCoordinateField, 1, 3, 1, 1, 100, 1, 2, 2);
        this.buttonListener = new DrawingInversionButtonListener();
        this.horizontalAxeButton.addActionListener(this.buttonListener);
        this.verticalAxeButton.addActionListener(this.buttonListener);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.commonAxeLabel = catalog.translate("commonAxe");
        this.horizontalAxeLabel = catalog.translate("horizontalAxe");
        this.verticalAxeLabel = catalog.translate("verticalAxe");
        this.axeCoordinateLabel = catalog.translate("axeCoordinate");
        this.noneAxeChoosedString = catalog.translate("noneAxeChoosed");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        this.buttonListener.setButtons(this.horizontalAxeButton, this.verticalAxeButton);
        this.horizontalAxeButton.setSelected(false);
        this.verticalAxeButton.setSelected(false);
        this.axeCoordinateField.setText("0.00");
    }

    @Override
    public boolean okAction() {
        boolean ok = true;
        boolean horizontalAxe = this.horizontalAxeButton.isSelected();
        boolean verticalAxe = this.verticalAxeButton.isSelected();
        if (horizontalAxe || verticalAxe) {
            String yText = this.axeCoordinateField.getText();
            DefaultPanel.CheckDoubleField checkCoordinate = this.checkDoubleField(yText, this.axeCoordinateLabel);
            boolean okValue = checkCoordinate.ok;
            if (okValue) {
                this.director.executeDrawingInversion(horizontalAxe, checkCoordinate.value);
                ok = true;
            }
        } else {
            JOptionPane.showMessageDialog(null, this.noneAxeChoosedString);
            ok = false;
        }
        return ok;
    }
}

