/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.points;

import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointsModelAdaptor;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.Selector;

public class PointsManager
implements Iterable<ScriptoriumPoint> {
    private PointsArea pointsArea;
    private PointPanel pointPanel;
    private PointsModelAdaptor pointsModel;
    private DrawingDirector director;
    private Drawing drawing;

    public void setDrawing(DrawingDirector director, Drawing drawing, PointsArea pointsArea) {
        this.director = director;
        this.drawing = drawing;
        this.pointsArea = pointsArea;
        this.pointsModel = new PointsModelAdaptor(drawing, (Selector)pointsArea);
        this.pointsModel.addSelectionListener(this.director);
    }

    public void reloadStyles() {
        if (this.pointPanel != null) {
            this.pointPanel.reloadStyles();
        }
    }

    @Override
    public Iterator<ScriptoriumPoint> iterator() {
        return this.pointsModel.iterator();
    }

    public void setPointPanel(PointPanel pointPanel) {
        this.pointPanel = pointPanel;
    }

    public void repaint() {
        this.pointsArea.repaint();
    }

    public void setSelectedItem(ScriptoriumPoint point, boolean notify) {
        this.pointsModel.setSelectedItem(point, notify);
    }

    public void addSelectedItem(ScriptoriumPoint point, boolean notify) {
        this.pointsModel.addSelectedItem(point, notify);
    }

    public ScriptoriumPoint getSelectedItem() {
        return (ScriptoriumPoint)this.pointsModel.getSelectedElement();
    }

    public List<ScriptoriumPoint> getSelectedItems() {
        return this.pointsModel.getSelectedElements();
    }

    public ScriptoriumPoint addPoint(double x, double y) {
        ScriptoriumPoint newPoint = new ScriptoriumPoint(this.drawing, this.director);
        int newPointId = this.newPointId();
        newPoint.setId(newPointId);
        newPoint.setX(x);
        newPoint.setY(y);
        newPoint.setVisible(true);
        newPoint.setSubId(0);
        this.pointsModel.append(newPoint);
        return newPoint;
    }

    public ScriptoriumPoint addPoint(ScriptoriumPoint point) {
        this.pointsModel.append(point);
        return point;
    }

    public ScriptoriumPoint removePoint(ScriptoriumPoint point) {
        this.pointsModel.removeElement(point);
        return point;
    }

    public int newPointId() {
        int maxId = 0;
        for (ScriptoriumPoint point : this.pointsModel) {
            if (maxId >= point.getId()) continue;
            maxId = point.getId();
        }
        return maxId + 1;
    }

    public GenericSelectionModel<ScriptoriumPoint> getPointsModel() {
        return this.pointsModel;
    }

    public void updateSelection() {
        ScriptoriumPoint point = this.getSelectedItem();
        this.updatePointPanel(point);
    }

    public void updatePointPanel(ScriptoriumPoint point) {
        this.pointPanel.setup(this.director, point);
    }

    public void updatePointPanel() {
        this.pointPanel.update();
    }

    public void setFocusToPanel() {
        this.pointPanel.setFocus();
    }

    public void unselectAll() {
        this.pointsModel.unselectAll();
    }
}

