/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.groups;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GlyphReferencesArea;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GlyphsModelAdaptor;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GroupFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords.GroupKeywordsArea;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.Selector;
import org.homelinux.elabor.ui.UITools;

public class GroupPanel
extends ScriptoriumPanel<GlyphGroup> {
    private static final long serialVersionUID = 1L;
    private GlyphGroup group;
    private JTextField nameField;
    private GlyphReferencesArea referencesArea;
    private GroupKeywordsArea keywordsArea;
    private String nameString;
    private String keywordsString;

    public GroupPanel(GroupFrame frame) {
        this.initLocale();
        JLabel nameLabel = new JLabel(this.nameString, 4);
        this.referencesArea = new GlyphReferencesArea();
        this.keywordsArea = new GroupKeywordsArea();
        LineBorder border = new LineBorder(Color.BLACK);
        TitledBorder titledBorder = new TitledBorder(border, this.keywordsString);
        this.keywordsArea.setBorder(titledBorder);
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        this.nameField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, nameLabel, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.nameField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, this.referencesArea, 0, 1, 2, 1, 100, 100, 1, 2);
        UITools.addComponent(this, this.keywordsArea, 0, 2, 2, 1, 100, 100, 1, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.nameString = catalog.translate("name");
        this.keywordsString = catalog.translate("keywords");
    }

    public void setup(GlyphGroup group) {
        this.group = group;
        String name = group.getName();
        this.nameField.setText(name);
        GlyphsModelAdaptor references = new GlyphsModelAdaptor(this.group, (Selector)this.referencesArea);
        this.referencesArea.setup(references);
        this.keywordsArea.setup(this.group);
    }

    @Override
    public boolean okAction() {
        boolean ok;
        String name = this.nameField.getText();
        boolean bl = ok = !name.isEmpty();
        if (ok) {
            this.group.setName(name);
        }
        return ok;
    }
}

