/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Equation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;

public class GeometricHelper {
    public static Point2D intersection(DraftVector vector1, DraftVector vector2) throws InvalidValueException {
        double a1 = vector1.getDx();
        double b1 = -vector2.getDx();
        double c1 = vector2.getX() - vector1.getX();
        double a2 = vector1.getDy();
        double b2 = -vector2.getDy();
        double c2 = vector2.getY() - vector1.getY();
        double delta = a2 * b1 - a1 * b2;
        if (Math.abs(delta) < 1.0E-8) {
            throw new InvalidValueException("intersection impossible");
        }
        double k1 = (b1 * c2 - b2 * c1) / delta;
        double x = vector1.getX() + vector1.getDx() * k1;
        double y = vector1.getY() + vector1.getDy() * k1;
        return new Point2D.Double(x, y);
    }

    public static Point2D symmetric(Point2D point, Point2D center) {
        double x = center.getX() * 2.0 - point.getX();
        double y = center.getY() * 2.0 - point.getY();
        return new Point2D.Double(x, y);
    }

    public static Point2D shift(DraftVector vector, double distance) {
        double x = vector.getX();
        double y = vector.getY();
        double dx = vector.getDx();
        double dy = vector.getDy();
        return GeometricHelper.shift(x, y, dx, dy, distance);
    }

    public static Point2D shift(Point2D point, double dx, double dy, double distance) {
        double x = point.getX();
        double y = point.getY();
        return GeometricHelper.shift(x, y, dx, dy, distance);
    }

    public static Point2D shift(double x, double y, double dx, double dy, double distance) {
        double norm = Math.sqrt(dx * dx + dy * dy);
        if (norm == 0.0) {
            norm = 1.0;
        }
        double destX = x + dx * distance / norm;
        double destY = y + dy * distance / norm;
        return new Point2D.Double(destX, destY);
    }

    public static Equation computeApproxEquation(Point2D[] points) {
        Array2DRowRealMatrix A = new Array2DRowRealMatrix(5, 5);
        ArrayRealVector B = new ArrayRealVector(5);
        double sx3y = 0.0;
        double sx2y2 = 0.0;
        double sxy3 = 0.0;
        double sy4 = 0.0;
        double sx3 = 0.0;
        double sx2y = 0.0;
        double sxy2 = 0.0;
        double sy3 = 0.0;
        double sx2 = 0.0;
        double sxy = 0.0;
        double sy2 = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        Point2D[] point2DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            double x = point.getX();
            double x2 = x * x;
            double x3 = x2 * x;
            double y = point.getY();
            double y2 = y * y;
            double y3 = y2 * y;
            double y4 = y3 * y;
            sx3y += x3 * y;
            sx2y2 += x2 * y2;
            sxy3 += x * y3;
            sy4 += y4;
            sx3 += x3;
            sx2y += x2 * y;
            sxy2 += x * y2;
            sy3 += y3;
            sx2 += x2;
            sxy += x * y;
            sy2 += y2;
            sx += x;
            sy += y;
            ++n2;
        }
        A.setEntry(0, 0, sx2y2);
        A.setEntry(0, 1, sxy3);
        A.setEntry(0, 2, sx2y);
        A.setEntry(0, 3, sxy2);
        A.setEntry(0, 4, sxy);
        B.setEntry(0, -sx3y);
        A.setEntry(1, 0, sxy3);
        A.setEntry(1, 1, sy4);
        A.setEntry(1, 2, sxy2);
        A.setEntry(1, 3, sy3);
        A.setEntry(1, 4, sy2);
        B.setEntry(1, -sx2y2);
        A.setEntry(2, 0, sx2y);
        A.setEntry(2, 1, sxy2);
        A.setEntry(2, 2, sx2);
        A.setEntry(2, 3, sxy);
        A.setEntry(2, 4, sx);
        B.setEntry(2, -sx3);
        A.setEntry(3, 0, sxy2);
        A.setEntry(3, 1, sy3);
        A.setEntry(3, 2, sxy);
        A.setEntry(3, 3, sy2);
        A.setEntry(3, 4, sy);
        B.setEntry(3, -sx2y);
        A.setEntry(4, 0, sxy);
        A.setEntry(4, 1, sy2);
        A.setEntry(4, 2, sx);
        A.setEntry(4, 3, sy);
        A.setEntry(4, 4, (double)points.length);
        B.setEntry(4, -sx2);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)A).getSolver();
        RealVector X = solver.solve((RealVector)B);
        double b = X.getEntry(0);
        double c = X.getEntry(1);
        double d = X.getEntry(2);
        double e = X.getEntry(3);
        double f = X.getEntry(4);
        return new Equation(1.0, b, c, d, e, f);
    }

    public static Shape buildConic(Equation equation, boolean arcOnly, Point2D start, Point2D end, Point2D[] points) throws NoninvertibleTransformException {
        Shape conic;
        if (equation.isEllipse()) {
            Arc2D.Double shape = new Arc2D.Double();
            shape.setFrameFromCenter(0.0, 0.0, 1.0, 1.0);
            AffineTransform transform = equation.getTransform();
            GeometricHelper.handleArc(transform, shape, arcOnly, start, end);
            conic = transform.createTransformedShape(shape);
        } else if (equation.isHyperbola()) {
            CubicCurve2D.Double cubic = new CubicCurve2D.Double();
            cubic.setCurve(points[0], points[1], points[2], points[3]);
            conic = cubic;
        } else {
            conic = GeometricHelper.buildLine(points);
        }
        return conic;
    }

    private static void handleArc(AffineTransform transform, Arc2D shape, boolean arcOnly, Point2D start, Point2D end) throws NoninvertibleTransformException {
        if (arcOnly) {
            Point2D startPoint = transform.inverseTransform(start, null);
            Point2D endPoint = transform.inverseTransform(end, null);
            shape.setAngles(startPoint, endPoint);
        } else {
            shape.setAngleExtent(360.0);
        }
    }

    public static Shape buildLine(Point2D[] points) {
        GeneralPath line = new GeneralPath();
        if (points.length > 0) {
            line.moveTo((float)points[0].getX(), (float)points[0].getY());
            int i = 1;
            while (i < Math.min(3, points.length)) {
                line.lineTo((float)points[i].getX(), (float)points[i].getY());
                ++i;
            }
        }
        return line;
    }

    public static DraftVector getVector(ScriptoriumPoint point, double fixedDx, double fixedDy, int firstPointId, int secondPointId, Iterable<ScriptoriumPoint> drawingPoints) {
        double dy;
        double dx;
        Point2D point2D = point.getPoint2D();
        double x = point2D.getX();
        double y = point2D.getY();
        if (fixedDx == 0.0 && fixedDy == 0.0) {
            ScriptoriumPoint firstPoint = ShapeAdapter.getReferredItem(firstPointId, drawingPoints);
            ScriptoriumPoint secondPoint = ShapeAdapter.getReferredItem(secondPointId, drawingPoints);
            dx = secondPoint.getX() - firstPoint.getX();
            dy = secondPoint.getY() - firstPoint.getY();
        } else {
            dx = fixedDx;
            dy = fixedDy;
        }
        return new DraftVector(x, y, dx, dy);
    }

    public static Point2D middlePoint(Point2D point1, Point2D point2) {
        return GeometricHelper.middlePoint(Arrays.asList(point1, point2));
    }

    public static Point2D middlePoint(List<Point2D> points) {
        double x = 0.0;
        double y = 0.0;
        for (Point2D point : points) {
            x += point.getX();
            y += point.getY();
        }
        int size = points.size();
        if (size > 0) {
            x /= (double)size;
            y /= (double)size;
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D symmetric(Point2D point, DraftVector vector) {
        Point2D symmetric;
        DraftVector ortogonal = new DraftVector(point, vector.getDy(), -vector.getDx());
        try {
            Point2D intersection = GeometricHelper.intersection(vector, ortogonal);
            symmetric = GeometricHelper.symmetric(point, intersection);
        }
        catch (InvalidValueException exc) {
            throw new RuntimeException(exc);
        }
        return symmetric;
    }

    public static Point2D middlePoint(Iterable<ScriptoriumPoint> points) {
        List<Point2D> points2D = GeometricHelper.extractPoint2D(points);
        return GeometricHelper.middlePoint(points2D);
    }

    public static List<Point2D> extractPoint2D(Iterable<ScriptoriumPoint> points) {
        KeyExtractor<Point2D, ScriptoriumPoint> extractor = point -> point.getPoint2D();
        ArrayList<Point2D> points2D = new ArrayList<Point2D>();
        StructuresHelper.buildCollection(points2D, points, extractor);
        return points2D;
    }

    public static int findCenter(List<Point2D> points) {
        Point2D middle = GeometricHelper.middlePoint(points);
        return GeometricHelper.findNext(points, middle);
    }

    public static int findNext(List<Point2D> points, Point2D middle) {
        int next = -1;
        double distance = Double.MAX_VALUE;
        int index = 0;
        while (index < points.size()) {
            double current = middle.distance(points.get(index));
            if (current < distance) {
                next = index;
                distance = current;
            }
            ++index;
        }
        return next;
    }

    public static double arsinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double arcosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static Point2D nearestPoint(DraftVector retta, ScriptoriumPoint point) {
        Point2D point2d = point.getPoint2D();
        return GeometricHelper.nearestPoint(retta, point2d);
    }

    public static Point2D nearestPoint(DraftVector retta, Point2D point) {
        Point2D nearest;
        double dx = retta.getDx();
        double dy = retta.getDy();
        DraftVector vector = new DraftVector(point, dy, -dx);
        try {
            nearest = GeometricHelper.intersection(retta, vector);
        }
        catch (InvalidValueException exc) {
            throw new RuntimeException(exc);
        }
        return nearest;
    }

    public static DraftVector orthogonal(Point2D center, Point2D point) {
        double x = center.getX();
        double y = center.getY();
        double dx = point.getX() - x;
        double dy = point.getY() - y;
        return new DraftVector(x, y, -dy, dx);
    }
}

