/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.batik.svggen.SVGGraphics2D;
import org.homelinux.elabor.itools.CartesianGraphics;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.LabelRotationType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.CancelAction;
import org.homelinux.elabor.scriptorium.gui.drawings.ColorManager;
import org.homelinux.elabor.scriptorium.gui.drawings.ColorSet;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingAreaMouseListener;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.EscapeAction;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointThinMovementListener;
import org.homelinux.elabor.scriptorium.gui.drawings.points.RemovePointKeyListener;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStroke;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStyle;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.ui.ColorHelper;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UIConstants;

public class DrawingArea
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String REMOVE_ACTION = "removeAction";
    private static final String ESCAPE_ACTION = "escapeAction";
    private static final int OFFSET = 10;
    private DrawingDirector drawingDirector;
    private Image backgroundImage;
    private Point2D clickedPoint;
    private Point2D dragStartPoint;
    private Point2D dragEndPoint;
    private CartesianGraphics cartesianGraphics;
    private boolean select;
    private boolean magnetic;
    private boolean showInvisibles;
    private boolean showBackground;
    private boolean showLabels;
    private boolean shading;
    private boolean showGrid;
    private PointThinMovementListener pointThinMovementListener;
    private RemovePointKeyListener undoPointSelectionListener;
    private DrawingAreaMouseListener mouseListener;
    private EscapeAction escapeAction;
    private CancelAction cancelAction;
    private boolean showDrawing;
    private boolean showPointRectangles;
    private boolean actions;
    private boolean nDraftOnly;

    public DrawingArea(DrawingAreaMouseListener mouseListener, boolean actions, boolean nDraftOnly) {
        this.nDraftOnly = nDraftOnly;
        this.clickedPoint = null;
        this.dragStartPoint = null;
        this.dragEndPoint = null;
        this.backgroundImage = null;
        this.setBackground(Color.white);
        this.initParameters();
        this.initActions();
        this.cartesianGraphics = new CartesianGraphics();
        this.pointThinMovementListener = new PointThinMovementListener();
        this.undoPointSelectionListener = new RemovePointKeyListener();
        mouseListener.setDrawingArea(this);
        this.mouseListener = mouseListener;
        this.addKeyListener(this.pointThinMovementListener);
        this.addKeyListener(this.undoPointSelectionListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.actions = actions;
    }

    private void initParameters() {
    }

    public void setSelectMode(boolean select) {
        this.select = select;
    }

    protected boolean isSelectMode() {
        return this.select;
    }

    protected Point2D getClickedPoint() {
        return this.clickedPoint;
    }

    public void setClickedPoint(Point2D clickedPoint) {
        this.clickedPoint = clickedPoint;
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap();
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(escapeKeyStroke, ESCAPE_ACTION);
        ActionMap actionMap = this.getActionMap();
        this.escapeAction = new EscapeAction();
        actionMap.put(ESCAPE_ACTION, this.escapeAction);
        KeyStroke deleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(deleteKeyStroke, REMOVE_ACTION);
        this.cancelAction = new CancelAction();
        actionMap.put(REMOVE_ACTION, this.cancelAction);
    }

    public void setup(DrawingDirector drawingDirector) {
        this.drawingDirector = drawingDirector;
        BackgroundImage image = this.drawingDirector.getBackgroundImage();
        this.loadBackgroundImage(image);
        this.pointThinMovementListener.setDrawingDirector(drawingDirector);
        this.undoPointSelectionListener.setDrawingDirector(drawingDirector);
        this.escapeAction.setDrawingDirector(drawingDirector);
        this.cancelAction.setDrawingDirector(drawingDirector);
        this.mouseListener.setDrawingDirector(drawingDirector);
        this.changeLayout();
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public CartesianGraphics getCartesianGraphics() {
        return this.cartesianGraphics;
    }

    public void loadBackgroundImage(BackgroundImage image) {
        if (image == null) {
            this.unloadBackgroundImage();
        } else {
            EditionManager editionmanager = EditionManager.getInstance();
            URI imageUri = image.getUri();
            Edition edition = image.getEdition();
            File imageFile = editionmanager.getImageFile(imageUri, edition);
            String imagePath = imageFile.getAbsolutePath();
            if (imageFile.exists()) {
                ImageIcon imageIcon = new ImageIcon(imagePath);
                this.backgroundImage = imageIcon.getImage();
                this.repaint();
            } else {
                UIConstants constants = UIConstants.getInstance();
                JOptionPane.showMessageDialog(null, String.valueOf(constants.fileNotFoundString) + ": " + imagePath, constants.informationString, 1);
                this.unloadBackgroundImage();
            }
            this.drawingDirector.applyTransform();
        }
    }

    public void unloadBackgroundImage() {
        this.backgroundImage = null;
        this.drawingDirector.applyTransform();
    }

    @Override
    public void paint(Graphics graphics) {
        this.draw(graphics, true);
    }

    private void draw(Graphics graphics, boolean gui) {
        super.paint(graphics);
        this.cartesianGraphics.setGraphics((Graphics2D)graphics);
        int leftX = this.drawingDirector.getOriginX();
        int ulY = this.drawingDirector.getOriginY();
        int height = this.drawingDirector.getHeight();
        int llY = ulY - height;
        int originX = 10 - leftX;
        int areaHeight = this.getHeight();
        int originY = areaHeight - 10 + llY;
        this.cartesianGraphics.setOrigin(originX, originY);
        Transform transform = this.drawingDirector.getBackgroundTransform();
        double magnification = transform.getMagnification();
        double rotation = transform.getRotation();
        double xTranslation = transform.getXTranslation();
        double yTranslation = transform.getYTranslation();
        this.cartesianGraphics.setCustomTransform(magnification, rotation, xTranslation, yTranslation);
        if (gui) {
            if (this.showBackground) {
                this.drawBackground();
            }
            if (this.showGrid) {
                this.drawGrid();
            }
            this.drawExportableArea(leftX, ulY, height);
            this.drawExpectedPointName();
        }
        if (!gui || this.showDrawing) {
            if (this.actions) {
                this.drawShapes(gui, true);
                this.drawPoints(gui, true);
            }
            if (!this.nDraftOnly) {
                this.drawShapes(gui, false);
            }
            this.drawComputedShapes();
            this.drawPoints(gui, false);
            this.drawDragRectangle();
        }
    }

    private void drawComputedShapes() {
        Iterable<Shape> computedShapes = this.drawingDirector.getComputedShapes();
        this.drawComputedShapes(computedShapes);
    }

    private void drawComputedShapes(Iterable<Shape> computedShapes) {
        Preferences preferences = Preferences.getInstance();
        Color color = preferences.getColor("lines_computed_color", false);
        this.cartesianGraphics.setColor(color);
        DefaultStyle style = new DefaultStyle();
        BasicStroke stroke = style.getStroke();
        this.cartesianGraphics.setStroke(stroke);
        for (Shape shape : computedShapes) {
            this.cartesianGraphics.drawShape(shape, false, ColorHelper.NULL_COLOR);
        }
    }

    private void drawExportableArea(int leftX, int ulY, int height) {
        int width = this.drawingDirector.getWidth();
        Preferences preferences = Preferences.getInstance();
        int lineWidth = preferences.getInteger("area_line_width");
        String lineStroke = preferences.getString("area_line_stroke");
        Color lineColor = preferences.getColor("area_line_color");
        DefaultStroke stroke = new DefaultStroke(lineWidth, lineStroke);
        this.cartesianGraphics.setStroke(stroke);
        this.cartesianGraphics.setColor(lineColor);
        this.cartesianGraphics.drawRectangle(leftX, ulY, width, height);
    }

    public void drawGrid() {
        this.cartesianGraphics.drawGrid(this.getSize());
    }

    private void drawExpectedPointName() {
        Point mp;
        String nextPointName;
        AbstractShape<?> innerShape;
        ScriptoriumShape selectedShape = this.drawingDirector.getSelectedShape();
        if (!this.select && selectedShape != null && (innerShape = selectedShape.getShape()).canAddPoint() && (nextPointName = innerShape.getNextUndefinedPointName()) != null && (mp = this.getMousePosition()) != null) {
            Preferences preferences = Preferences.getInstance();
            Color pointSelectedColor = preferences.getColor("points_selected_color");
            this.cartesianGraphics.setColor(pointSelectedColor);
            Point2D p = this.getPoint(((Point2D)mp).getX(), ((Point2D)mp).getY());
            Font font = this.getFont();
            this.cartesianGraphics.setFont(font);
            this.cartesianGraphics.drawString(p, nextPointName, 0.0, CharRotation.NORMAL, 0.0);
        }
    }

    private void drawShapes(boolean gui, boolean original) {
        GenericSelectionModel<ScriptoriumShape> shapes = this.drawingDirector.getShapesModel();
        this.drawShapes(shapes, gui, original);
    }

    private void drawShapes(Iterable<ScriptoriumShape> shapes, boolean gui, boolean original) {
        List<ScriptoriumShape> selectedShapes = this.drawingDirector.getSelectedShapes();
        for (ScriptoriumShape shape : shapes) {
            boolean selected = selectedShapes.contains(shape);
            this.drawShape(shape, selected, gui, original);
        }
    }

    private void drawShape(ScriptoriumShape shape, boolean selected, boolean gui, boolean original) {
        AbstractShape<?> innerShape = shape.getShape();
        this.drawShape(innerShape, selected, gui, original);
    }

    private void drawShape(AbstractShape<?> innerShape, boolean selected, boolean gui, boolean original) {
        boolean visible = innerShape.isVisible();
        Style style = this.getShapeStyle(innerShape);
        ColorSet colorSet = ColorManager.getShapeColorSet(innerShape, selected, gui, this.showInvisibles, style, original);
        if ((gui || visible) && innerShape.isComplete()) {
            this.drawJustShape(gui, innerShape, style, colorSet, original);
        }
        String label = innerShape.getLabel();
        List<ScriptoriumPoint> points = this.drawingDirector.getShapePoints(innerShape);
        int pointsNumber = points.size();
        if (!label.isEmpty() && this.showLabels && pointsNumber > 0) {
            this.drawShapeLabel(innerShape, label, style, colorSet);
            if (gui) {
                this.drawShapeAnchor(innerShape, colorSet);
            }
        }
    }

    private Style getShapeStyle(AbstractShape<?> innerShape) {
        String styleName = innerShape.getStyleName();
        return this.drawingDirector.getStyle(styleName);
    }

    private void drawJustShape(boolean gui, AbstractShape<?> innerShape, Style style, ColorSet colorSet, boolean original) {
        BasicStroke stroke = style.getStroke();
        this.cartesianGraphics.setStroke(stroke);
        Color shapeColor = colorSet.getColor();
        if (shapeColor != null) {
            Color shapeFillColor = colorSet.getFillColor();
            this.cartesianGraphics.setColor(shapeColor);
            Shape shape = this.drawingDirector.getShape(innerShape, original);
            boolean shade = gui && this.shading;
            this.cartesianGraphics.drawShape(shape, shade, shapeFillColor);
        }
    }

    private void drawShapeLabel(AbstractShape<?> innerShape, String label, Style style, ColorSet colorSet) {
        Color color = colorSet.getLabelColor();
        this.cartesianGraphics.setColor(color);
        Font labelFont = DrawingArea.getLabelFont(style);
        this.cartesianGraphics.setFont(labelFont);
        LabelRotationType rotationType = innerShape.getLabelRotationType();
        double rotation = innerShape.getLabelRotation();
        List<ScriptoriumPoint> shapePoints = this.drawingDirector.getShapePoints(innerShape);
        Point2D[] points2D = ShapeAdapter.getPoints2D(shapePoints);
        double direction = rotationType.getLabelRotation(points2D, rotation);
        CharRotation charRotation = innerShape.getCharRotation();
        Point2D absoluteP = this.getAbsolutePosition(innerShape);
        double charInterspace = innerShape.getCharInterspace();
        if (charInterspace == 0.0) {
            double fontSize = style.getLabelFontSize();
            charInterspace = fontSize / 10.0;
        }
        this.cartesianGraphics.drawString(absoluteP, label, direction, charRotation, charInterspace);
    }

    private void drawShapeAnchor(AbstractShape<?> innerShape, ColorSet colorSet) {
        Point2D center = this.getAbsolutePosition(innerShape);
        Color anchorColor = colorSet.getAnchorColor();
        if (anchorColor != null) {
            Preferences preferences = Preferences.getInstance();
            int labelAnchorDiagonal = preferences.getInteger("label_anchor_diagonal");
            this.cartesianGraphics.setColor(anchorColor);
            BasicStroke stroke = new BasicStroke(1.0f);
            this.cartesianGraphics.setStroke(stroke);
            this.cartesianGraphics.drawAnchor(center, labelAnchorDiagonal);
        }
    }

    private Point2D getAbsolutePosition(AbstractShape<?> innerShape) {
        Point2D relativeP = innerShape.getLabelPosition();
        double relativeX = relativeP.getX();
        double relativeY = relativeP.getY();
        Point2D anchorP = this.drawingDirector.getAnchorPosition(innerShape);
        double anchorX = anchorP.getX();
        double anchorY = anchorP.getY();
        return new Point2D.Double(relativeX + anchorX, relativeY + anchorY);
    }

    private static Font getLabelFont(Style style) {
        int labelFontSize = style.getLabelFontSize();
        String fontName = style.getFontName();
        Font labelFont = new Font(fontName, 0, labelFontSize);
        return labelFont;
    }

    public void setDragStartPoint(Point2D point) {
        this.dragStartPoint = point;
    }

    public Point2D getDragStartPoint() {
        return this.dragStartPoint;
    }

    public void setDragEndPoint(Point2D point) {
        this.dragEndPoint = point;
    }

    private void drawPoints(boolean gui, boolean original) {
        Iterable<ScriptoriumPoint> drawingPoints = this.drawingDirector.getPoints();
        List<ScriptoriumPoint> selectedPoints = this.drawingDirector.getSelectedPoints();
        List<ScriptoriumShape> selectedShapes = this.drawingDirector.getSelectedShapes();
        for (ScriptoriumPoint point : drawingPoints) {
            Style style = this.getPointStyle(point);
            ColorSet colorSet = ColorManager.getPointColorSet(point, drawingPoints, selectedPoints, selectedShapes, gui, this.showInvisibles, style, original);
            this.drawPointNeighbour(point, gui, colorSet);
            Color color = colorSet.getColor();
            if (color == null) continue;
            DrawingArea.drawPoint(this.cartesianGraphics, point, colorSet, style);
        }
        if (this.clickedPoint != null) {
            ScriptoriumPoint point;
            point = new ScriptoriumPoint(selectedPoints.get(0), null);
            point.set(this.clickedPoint);
            Preferences preferences = Preferences.getInstance();
            Color color = preferences.getColor("points_preview_color");
            ColorSet previewColorSet = new ColorSet();
            previewColorSet.setColor(color);
            this.drawPointNeighbour(point, gui, previewColorSet);
        }
    }

    private Style getPointStyle(ScriptoriumPoint point) {
        String styleName = point.getStyleName();
        Style style = this.drawingDirector.getStyle(styleName);
        return style;
    }

    private static void drawPoint(CartesianGraphics g, ScriptoriumPoint point, ColorSet colorSet, Style style) {
        Point2D p = point.getPoint2D();
        Color color = colorSet.getColor();
        g.setColor(color);
        int pointSize = style.getPointSize();
        g.fillOval(p, pointSize, pointSize);
    }

    private void drawPointNeighbour(ScriptoriumPoint point, boolean gui, ColorSet colorSet) {
        Point2D p = point.getPoint2D();
        Point2D ll = point.getLowerLeftCorner();
        Point2D ur = point.getUpperRightCorner();
        double x_ll = ll.getX() + p.getX();
        double y_ll = ll.getY() + p.getY();
        double x_ur = ur.getX() + p.getX();
        double y_ur = ur.getY() + p.getY();
        Point2D.Double tll = new Point2D.Double(x_ll, y_ll);
        Point2D.Double tur = new Point2D.Double(x_ur, y_ur);
        String label = point.getLabel();
        if (gui && this.showPointRectangles) {
            this.drawPointLabelRectangle(tll, tur, colorSet);
        }
        if (!label.isEmpty()) {
            if (this.showLabels || !gui) {
                this.drawPointLabel(point, label, ll, ur, tll, tur, colorSet);
            }
            if (gui) {
                DrawingArea.drawPointAnchor(this.cartesianGraphics, ll, ur, tll, tur, colorSet);
            }
        }
    }

    private void drawPointLabelRectangle(Point2D tll, Point2D tur, ColorSet colorSet) {
        Color pointLabelColor = colorSet.getLabelColor();
        if (pointLabelColor != null) {
            this.cartesianGraphics.setColor(pointLabelColor);
            Rectangle2D.Double labelRectangle = new Rectangle2D.Double();
            labelRectangle.setFrameFromDiagonal(tll, tur);
            Preferences preferences = Preferences.getInstance();
            int prefLineWidth = preferences.getInteger("lines_width") / 2;
            int lineWidth = Math.max(1, prefLineWidth);
            BasicStroke stroke = new BasicStroke(lineWidth);
            this.cartesianGraphics.setStroke(stroke);
            this.cartesianGraphics.drawShape(labelRectangle, this.shading, ColorHelper.NULL_COLOR);
        }
    }

    private static void drawPointAnchor(CartesianGraphics g, Point2D ll, Point2D ur, Point2D tll, Point2D tur, ColorSet colorSet) {
        Point2D center = DrawingArea.getPointLabelRectangleCenter(g, ll, ur, tll, tur);
        Color anchorColor = colorSet.getAnchorColor();
        if (anchorColor != null) {
            g.setColor(anchorColor);
            BasicStroke stroke = new BasicStroke(1.0f);
            g.setStroke(stroke);
            Preferences preferences = Preferences.getInstance();
            int labelAnchorDiagonal = preferences.getInteger("label_anchor_diagonal");
            g.drawAnchor(center, labelAnchorDiagonal);
        }
    }

    private void drawPointLabel(ScriptoriumPoint point, String label, Point2D ll, Point2D ur, Point2D tll, Point2D tur, ColorSet colorSet) {
        Style style = this.getPointStyle(point);
        Color pointLabelColor = colorSet.getLabelColor();
        if (pointLabelColor != null) {
            this.cartesianGraphics.setColor(pointLabelColor);
            Font labelFont = DrawingArea.getLabelFont(style);
            this.cartesianGraphics.setFont(labelFont);
            double charInterspace = point.getCharInterspace();
            if (charInterspace == 0.0) {
                double fontSize = style.getLabelFontSize();
                charInterspace = fontSize / 10.0;
            }
            Point2D center = DrawingArea.getPointLabelRectangleCenter(this.cartesianGraphics, ll, ur, tll, tur);
            double theta = -Math.PI / 180 * (double)point.getLabelRotation();
            CharRotation charRotation = point.getCharRotation();
            this.cartesianGraphics.drawString(center, label, theta, charRotation, charInterspace);
        }
    }

    private static Point2D getPointLabelRectangleCenter(CartesianGraphics g, Point2D ll, Point2D ur, Point2D tll, Point2D tur) {
        Point2D.Double center;
        double x_label = (tll.getX() + tur.getX()) / 2.0;
        double y_label = (tll.getY() + tur.getY()) / 2.0;
        if (ll.getX() + ll.getY() + ur.getX() + ur.getY() == 0.0) {
            FontMetrics metrics = g.getFontMetrics();
            int hgt = metrics.getAscent() - metrics.getDescent();
            center = new Point2D.Double(x_label, y_label + (double)(hgt / 2));
        } else {
            center = new Point2D.Double(x_label, y_label);
        }
        return center;
    }

    private void drawBackground() {
        if (this.backgroundImage != null) {
            this.cartesianGraphics.drawImage(this.backgroundImage);
        }
    }

    private void drawDragRectangle() {
        if (this.dragStartPoint != null && this.dragEndPoint != null) {
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal(this.dragStartPoint, this.dragEndPoint);
            Preferences preferences = Preferences.getInstance();
            Color dragPreviewColor = preferences.getColor("drag_preview_color");
            this.cartesianGraphics.setColor(dragPreviewColor);
            this.cartesianGraphics.drawShape(rect, false, ColorHelper.NULL_COLOR);
        }
    }

    public void setShowInvisibles(boolean showInvisibles) {
        this.showInvisibles = showInvisibles;
        this.repaint();
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.repaint();
    }

    public void setShowPointRectangles(boolean showRectangles) {
        this.showPointRectangles = showRectangles;
        this.repaint();
    }

    public void setShowBackground(boolean showBackground) {
        this.showBackground = showBackground;
        this.repaint();
    }

    public void setShowDrawing(boolean showDrawing) {
        this.showDrawing = showDrawing;
        this.repaint();
    }

    public void setShading(boolean shading) {
        this.shading = shading;
        this.repaint();
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.repaint();
    }

    public void setMagnetic(boolean magnetic) {
        this.magnetic = magnetic;
    }

    private static double snapToGrid(double coordinate) {
        Preferences prefs = Preferences.getInstance();
        int gridSize = prefs.getInteger("grid_size");
        double step = Math.round(coordinate / (double)gridSize);
        return (double)gridSize * step;
    }

    protected Point2D snapToGrid(Point2D p) {
        Point2D snapped = p;
        if (this.magnetic) {
            double snapX = DrawingArea.snapToGrid(p.getX());
            double snapY = DrawingArea.snapToGrid(p.getY());
            snapped = new Point2D.Double(snapX, snapY);
        }
        return snapped;
    }

    public Point2D getPoint(double x, double y) {
        Point2D.Double p = new Point2D.Double(x, y);
        return this.cartesianGraphics.getPoint(p);
    }

    public static double pointSegmentDistance(Point2D p, Point2D a, Point2D b) {
        double x = p.getX();
        double y = p.getY();
        double aX = a.getX();
        double aY = a.getY();
        double bX = b.getX();
        double bY = b.getY();
        return DrawingArea.getDistance(x, y, aX, aY, bX, bY);
    }

    private static double getDistance(double x, double y, double aX, double aY, double bX, double bY) {
        double ratio;
        double lineLength = Math.sqrt(Math.pow(bX - aX, 2.0) + Math.pow(bY - aY, 2.0));
        if (lineLength == 0.0) {
            ratio = 0.0;
        } else {
            ratio = (x - aX) * (bX - aX) / Math.pow(lineLength, 2.0) + (y - aY) * (bY - aY) / Math.pow(lineLength, 2.0);
            if (ratio > 1.0) {
                ratio = 1.0;
            }
            if (ratio < 0.0) {
                ratio = 0.0;
            }
        }
        return Math.sqrt(Math.pow(x - (aX + ratio * (bX - aX)), 2.0) + Math.pow(y - (aY + ratio * (bY - aY)), 2.0));
    }

    protected ScriptoriumShape getNearestShape(Point2D point) {
        ScriptoriumShape nearShape = this.getNearestLine(point);
        if (nearShape == null) {
            nearShape = this.getLastContainingShape(point);
        }
        return nearShape;
    }

    private ScriptoriumShape getNearestLine(Point2D point) {
        ScriptoriumShape nearShape = null;
        Preferences preferences = Preferences.getInstance();
        int minLineDistance = preferences.getInteger("line_selection_distance");
        double minDistance = minLineDistance + 1;
        GenericSelectionModel<ScriptoriumShape> shapes = this.drawingDirector.getShapesModel();
        for (ScriptoriumShape scriptoriumShape : shapes) {
            AbstractShape<?> innerShape;
            Shape shape;
            if (scriptoriumShape.getLine() == null || (shape = this.drawingDirector.getShape(innerShape = scriptoriumShape.getShape(), false)) == null) continue;
            List<ScriptoriumPoint> shapePoints = this.drawingDirector.getShapePoints(innerShape);
            Iterator<ScriptoriumPoint> pointsIterator = shapePoints.iterator();
            ScriptoriumPoint first = pointsIterator.next();
            while (pointsIterator.hasNext()) {
                Point2D second2d;
                ScriptoriumPoint second = pointsIterator.next();
                Point2D first2d = first.getPoint2D();
                double distance = DrawingArea.pointSegmentDistance(point, first2d, second2d = second.getPoint2D());
                if (distance < minDistance) {
                    minDistance = distance;
                    nearShape = scriptoriumShape;
                }
                first = second;
            }
        }
        return nearShape;
    }

    private ScriptoriumShape getLastContainingShape(Point2D point) {
        ScriptoriumShape nearShape = null;
        GenericSelectionModel<ScriptoriumShape> shapes = this.drawingDirector.getShapesModel();
        for (ScriptoriumShape scriptoriumShape : shapes) {
            AbstractShape<?> innerShape = scriptoriumShape.getShape();
            Shape shape = this.drawingDirector.getShape(innerShape, false);
            if (!innerShape.isComplete() || !shape.contains(point)) continue;
            nearShape = scriptoriumShape;
        }
        return nearShape;
    }

    public void showClickedPoint(Point2D point) {
        this.clickedPoint = point;
        this.repaint();
    }

    protected ScriptoriumPoint addPoint(Point2D pClick) {
        Point2D point = this.snapToGrid(pClick);
        double x = point.getX();
        double y = point.getY();
        ScriptoriumPoint newPoint = this.drawingDirector.addPoint(x, y);
        return newPoint;
    }

    public void changeLayout() {
        int width = this.drawingDirector.getWidth();
        int height = this.drawingDirector.getHeight();
        Dimension preferredSize = new Dimension(width + 20, height + 20);
        this.setPreferredSize(preferredSize);
        Container parent = this.getParent();
        if (parent != null) {
            parent.doLayout();
        }
    }

    public void export(SVGGraphics2D graphics) {
        this.draw((Graphics)graphics, false);
    }

    public void buildSelectedLabelRect() {
        if (this.dragStartPoint != null && this.dragEndPoint != null) {
            this.drawingDirector.setSelectedLabelRect(this.dragStartPoint, this.dragEndPoint);
        }
        this.dragStartPoint = null;
        this.dragEndPoint = null;
    }

    public void toggleOriginal() {
        this.actions = !this.actions;
        this.repaint();
    }
}

