/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.comments;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.comments.CommentFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class CommentsPanel
extends OldScriptoriumListArea<Comment> {
    public static final long serialVersionUID = 1L;
    private CommentFrame comment_frame;

    public CommentsPanel() {
        super(false, true, true);
        this.setBorder(new LineBorder(Color.black));
    }

    @Override
    public void setup(ScriptoriumDirector director, Comment comment) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Comment> comments = content.getComments();
        super.setup(director, comments, comment);
    }

    private void openCommentFrame(int index) {
        if (this.comment_frame == null) {
            this.comment_frame = new CommentFrame();
        }
        GenericSelectionModel<Comment> model = this.getModel();
        this.comment_frame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void editAction(int index, Comment item) {
        this.openCommentFrame(index);
    }

    @Override
    public void remAction(int index, Comment item) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(item);
    }

    @Override
    public boolean closing() {
        if (this.comment_frame != null) {
            this.comment_frame.dispose();
        }
        return super.closing();
    }
}

