/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.EditionMapper;
import org.homelinux.elabor.scriptorium.ecomponents.ImpossibleSplitException;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextNotFoundException;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedComposite;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.services.StyledDocumentEditionVisitor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;

public class ScriptoriumStyledDocument
extends DefaultStyledDocument
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private Edition edition;
    private EditionMapper mapper;
    public static final String CRUX_LEFT_DELIMITER = "\u2020";
    public static final String CRUX_RIGHT_DELIMITER = "\u2020";
    public static final String EXPU_LEFT_DELIMITER = "[";
    public static final String EXPU_RIGHT_DELIMITER = "]";
    public static final String LI_LEFT_DELIMITER = "\u00b0\t";
    public static final String LI_RIGHT_DELIMITER = "";
    public static final String VARIANT_DELIMITER = "|";
    public String impossibleSplit;

    public ScriptoriumStyledDocument(Edition edition) {
        this.initLocale();
        this.edition = edition;
        this.mapper = new EditionMapper(edition);
        this.addDocumentListener(this);
        Preferences preferences = Preferences.getInstance();
        Style normalStyle = this.addStyle("normal", null);
        StyleConstants.setFontFamily(normalStyle, "serif");
        StyleConstants.setFontSize(normalStyle, preferences.getInteger("font_size"));
        StyleConstants.setForeground(normalStyle, Color.black);
        this.setParagraphAttributes(0, 0, normalStyle, false);
        Style citationStyle = this.addStyle("citation", normalStyle);
        Color citationColor = preferences.getColor("citation_color");
        StyleConstants.setForeground(citationStyle, citationColor);
        Style cruxStyle = this.addStyle("crux", normalStyle);
        Color cruxColor = preferences.getColor("crux_color");
        StyleConstants.setForeground(cruxStyle, cruxColor);
        Style dateStyle = this.addStyle("date_token", normalStyle);
        Color dateColor = preferences.getColor("date_token_color");
        StyleConstants.setForeground(dateStyle, dateColor);
        Style enunciatioStyle = this.addStyle("enunciatio", normalStyle);
        Color enunciatioColor = preferences.getColor("enunciatio_color");
        StyleConstants.setForeground(enunciatioStyle, enunciatioColor);
        Style expunctioStyle = this.addStyle("expunctio", normalStyle);
        Color expunctioColor = preferences.getColor("expunctio_color");
        StyleConstants.setForeground(expunctioStyle, expunctioColor);
        Style formulaStyle = this.addStyle("math", normalStyle);
        StyleConstants.setItalic(formulaStyle, true);
        Color formulaColor = preferences.getColor("formula_color");
        StyleConstants.setForeground(formulaStyle, formulaColor);
        Style math_concept_style = this.addStyle("mathconcept", normalStyle);
        Color math_concept_color = preferences.getColor("math_concept_color");
        StyleConstants.setForeground(math_concept_style, math_concept_color);
        Style nameStyle = this.addStyle("name", normalStyle);
        Color nameColor = preferences.getColor("name_color");
        StyleConstants.setForeground(nameStyle, nameColor);
        Style placeStyle = this.addStyle("place", normalStyle);
        Color placeColor = preferences.getColor("place_color");
        StyleConstants.setForeground(placeStyle, placeColor);
        Style readingStyle = this.addStyle("reading", normalStyle);
        Color readingColor = preferences.getColor("reading_color");
        StyleConstants.setForeground(readingStyle, readingColor);
        Style tongueStyle = this.addStyle("tongue", normalStyle);
        StyleConstants.setItalic(tongueStyle, true);
        Style workStyle = this.addStyle("work", normalStyle);
        Color workColor = preferences.getColor("work_color");
        StyleConstants.setForeground(workStyle, workColor);
        this.registerImageStyle("image", "icons/image.png");
        this.registerImageStyle("annotation", "icons/annotation.png");
        this.registerImageStyle("comment", "icons/comment.png");
        this.registerImageStyle("drawing", "icons/drawing.png");
        this.registerImageStyle("folium", "icons/folium.png");
        this.registerImageStyle("integratio", "icons/integratio.png");
        this.registerImageStyle("qdr", "icons/qdr.png");
        this.registerImageStyle("rtt", "icons/rtt.png");
        this.registerImageStyle("part", "icons/part.png");
        this.registerImageStyle("unit", "icons/unit.png");
        this.fillStyledDocument();
        this.setParagraphAttributes(0, 0, normalStyle, false);
    }

    public void setDefaultFont(String font_name) {
        Style normal_style = this.getStyle("normal");
        StyleConstants.setFontFamily(normal_style, font_name);
        this.styleChanged(normal_style);
        this.fillStyledDocument();
        this.setParagraphAttributes(0, 0, normal_style, true);
    }

    private void registerImageStyle(String stylename, String filename) {
        Style normal = this.getStyle("normal");
        Style style = this.addStyle(stylename, normal);
        URL icon_url = this.getClass().getClassLoader().getResource(filename);
        ImageIcon icon = new ImageIcon(icon_url);
        StyleConstants.setIcon(style, icon);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.impossibleSplit = catalog.translate("impossibleSplit");
    }

    public String getText() {
        String text = LI_RIGHT_DELIMITER;
        try {
            text = super.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return text;
    }

    public boolean defineToken(int offset, int length, ValuedComposite<?> token) {
        boolean result = false;
        this.removeDocumentListener(this);
        try {
            Style style;
            this.splitComponent(offset, length, token);
            result = true;
            if (length > 0 && (style = this.getStyle(token.getElementName())) != null) {
                this.setCharacterAttributes(offset, length, style, false);
            }
        }
        catch (ImpossibleSplitException e) {
            JOptionPane.showMessageDialog(null, this.impossibleSplit, UIConstants.getInstance().errorString, 0);
        }
        this.addDocumentListener(this);
        return result;
    }

    public boolean defineNonValuedToken(int offset, EditionComponent<?> token) {
        boolean result = false;
        this.removeDocumentListener(this);
        try {
            this.splitComponent(offset, token);
            result = true;
            try {
                String elementName = token.getElementName();
                Style style = this.getStyle(elementName);
                this.replace(offset, 0, "*", style);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        catch (ImpossibleSplitException e) {
            JOptionPane.showMessageDialog(null, this.impossibleSplit, UIConstants.getInstance().errorString, 0);
        }
        this.addDocumentListener(this);
        return result;
    }

    public void appendString(String text, AttributeSet style) {
        try {
            this.insertString(this.getLength(), text, style);
        }
        catch (BadLocationException e) {
            String message = e.getMessage();
            System.err.println(message);
            UIConstants instance = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, String.valueOf(instance.internalErrorString) + message, instance.errorString, 0);
        }
    }

    public void insertString(int offset, String text) {
        Text node;
        try {
            node = this.mapper.getTextByOffset(offset);
        }
        catch (TextNotFoundException exc) {
            EditionComponent<?> previous = exc.getPreviousNode();
            EditionComposite<Text> parent = previous.getParent();
            node = new Text(parent);
            parent.addChildAfter(previous, node);
        }
        int rel_offset = offset - this.mapper.getComponentOffset(node);
        node.insertString(rel_offset, text);
    }

    public void removeString(int offset, int length) {
        try {
            Text node = this.mapper.getTextByOffset(offset);
            int rel_offset = offset - this.mapper.getComponentOffset(node);
            this.removeString(node, rel_offset, length);
            this.edition.normalize();
        }
        catch (TextNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void removeString(Text node, int offset, int length) {
        StringBuffer text = new StringBuffer(node.getValue());
        int len = Math.min(length, text.length() - offset);
        if (len > 0) {
            text.delete(offset, offset + len);
            node.setValue(text.toString());
        }
        if (len < length) {
            try {
                int rel_offset = this.mapper.getComponentOffset(node) + text.length() + 1;
                Text nextNode = this.mapper.getTextByOffset(rel_offset);
                this.removeString(nextNode, 0, length - len);
            }
            catch (TextNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void replaceString(int offset, EditionComponent<?> component, String text) {
        this.removeDocumentListener(this);
        try {
            int textLength = component.getTextLength();
            String elementName = component.getElementName();
            Style style = this.getStyle(elementName);
            this.replace(offset, textLength, text, style);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.addDocumentListener(this);
    }

    private void splitComponent(int offset, EditionComponent<?> token) throws ImpossibleSplitException {
        Text text = this.getTextByOffset(offset);
        if (text == null) {
            Content content = this.edition.getContent();
            content.addChild(token);
        } else {
            int relOffset = this.findRelativeOffset(offset, 0, text);
            EditionComposite<?> parent = text.getParent();
            parent.insertComponent(text, relOffset, token);
        }
    }

    private void splitComponent(int offset, int length, ValuedComposite<?> token) throws ImpossibleSplitException {
        Text text = this.getTextByOffset(offset);
        int relOffset = this.findRelativeOffset(offset, length, text);
        EditionComposite<?> parent = text.getParent();
        parent.defineComposite(text, relOffset, length, token);
    }

    private int findRelativeOffset(int offset, int length, Text text) throws ImpossibleSplitException {
        String value = text.getValue();
        if (value.length() < length) {
            throw new ImpossibleSplitException();
        }
        int relOffset = offset - this.mapper.getComponentOffset(text);
        return relOffset;
    }

    private Text getTextByOffset(int offset) {
        Text text;
        try {
            text = this.mapper.getTextByOffset(offset);
        }
        catch (TextNotFoundException exc) {
            text = exc.getNextTextNode();
        }
        return text;
    }

    public void resetStyledDocument() {
        this.removeDocumentListener(this);
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            System.err.println(e.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, String.valueOf(UIConstants.getInstance().internalErrorString) + ": " + e.getLocalizedMessage(), UIConstants.getInstance().errorString, 0);
        }
        this.addDocumentListener(this);
    }

    public void fillStyledDocument() {
        this.resetStyledDocument();
        this.removeDocumentListener(this);
        StyledDocumentEditionVisitor reader = new StyledDocumentEditionVisitor();
        reader.setStyledDocument(this);
        reader.visit(this.edition);
        this.addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String text;
        try {
            text = this.getText(e.getOffset(), e.getLength());
        }
        catch (BadLocationException exc) {
            text = "<unknown>";
        }
        this.insertString(e.getOffset(), text);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.removeString(e.getOffset(), e.getLength());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

