/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.services.Finder;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class FindPanel
extends ScriptoriumPanel<EditionComponent<?>>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String findLabelString;
    private String findTooltipString;
    private String directionLabelString;
    private String forwardLabelString;
    private String backwardLabelString;
    private String optionsLabelString;
    private String caseSensitiveLabelString;
    private String wrapSearchLabelString;
    private String wholeWordLabelString;
    private JTextField findText;
    private JRadioButton forward;
    private JRadioButton backward;
    private JCheckBox caseSensitive;
    private JCheckBox wrapSearch;
    private JCheckBox wholeWord;
    private JButton findButton;

    public FindPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        JLabel findLabel = new JLabel(this.findLabelString, 2);
        JLabel directionLabel = new JLabel(this.directionLabelString, 0);
        JLabel optionsLabel = new JLabel(this.optionsLabelString, 0);
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color fieldColor = preferences.getColor("text_fields_editable_bg_color");
        this.findText = Tools.setupTextField(this, fontSize, fieldColor, frame);
        this.findText.addActionListener(this);
        this.forward = new JRadioButton(this.forwardLabelString);
        this.backward = new JRadioButton(this.backwardLabelString);
        JPanel directionPanel = this.setupDirectionPanel(directionLabel);
        this.caseSensitive = new JCheckBox(this.caseSensitiveLabelString);
        this.wrapSearch = new JCheckBox(this.wrapSearchLabelString);
        this.wholeWord = new JCheckBox(this.wholeWordLabelString);
        JPanel optionsPanel = this.setupOptionsPanel(optionsLabel);
        this.findButton = UITools.setupButton(this.findLabelString, this.findTooltipString, this, true);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, findLabel, 0, 0, 1, 1, 1, 0, 2, 2);
        UITools.addComponent(this, this.findText, 1, 0, 1, 1, 100, 0, 2, 2);
        UITools.addComponent(this, directionPanel, 0, 1, 2, 1, 0, 0, 2, 2);
        UITools.addComponent(this, optionsPanel, 0, 2, 2, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.findButton, 0, 3, 2, 1, 100, 0, 2, 2);
    }

    private JPanel setupDirectionPanel(JLabel direction_label) {
        ButtonGroup direction_group = new ButtonGroup();
        direction_group.add(this.forward);
        direction_group.add(this.backward);
        JPanel direction_panel = new JPanel(new GridLayout(0, 1));
        direction_panel.add(direction_label);
        direction_panel.add(this.forward);
        direction_panel.add(this.backward);
        direction_panel.setBorder(new LineBorder(Color.gray));
        return direction_panel;
    }

    private JPanel setupOptionsPanel(JLabel options_label) {
        JPanel options_panel = new JPanel(new GridLayout(0, 1));
        options_panel.add(options_label);
        options_panel.add(this.caseSensitive);
        options_panel.add(this.wrapSearch);
        options_panel.add(this.wholeWord);
        options_panel.setBorder(new LineBorder(Color.gray));
        return options_panel;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.findLabelString = catalog.translate("find");
        this.findTooltipString = catalog.translate("find_tooltip");
        this.directionLabelString = catalog.translate("direction");
        this.forwardLabelString = catalog.translate("forward");
        this.backwardLabelString = catalog.translate("backward");
        this.optionsLabelString = catalog.translate("options");
        this.caseSensitiveLabelString = catalog.translate("case_sensitive");
        this.wrapSearchLabelString = catalog.translate("wrap_search");
        this.wholeWordLabelString = catalog.translate("whole_word");
    }

    @Override
    public void setup(ScriptoriumDirector director) {
        super.setup(director);
        Finder finder = director.getFinder();
        this.forward.setSelected(finder.searchForward());
        this.backward.setSelected(!finder.searchForward());
        this.caseSensitive.setSelected(finder.isCaseSensitive());
        this.wrapSearch.setSelected(finder.wrapSearch());
        this.wholeWord.setSelected(finder.wholeWord());
    }

    private void setupFinder() {
        Finder finder = this.getDirector().getFinder();
        if (this.forward.isSelected()) {
            finder.setDirection(Finder.Directions.FORWARD);
        } else if (this.backward.isSelected()) {
            finder.setDirection(Finder.Directions.BACKWARD);
        }
        finder.setCaseSensitive(this.caseSensitive.isSelected());
        finder.setWholeWord(this.wholeWord.isSelected());
        finder.setWrapSearch(this.wrapSearch.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.setupFinder();
        String match = this.findText.getText();
        int position = this.getDirector().getFinder().find(match);
        if (position >= 0) {
            this.getDirector().highlightText(position, match.length());
        }
    }
}

