/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.exports;

import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Author;
import org.homelinux.elabor.scriptorium.ecomponents.AuthorPlace;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.DocumentType;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionDate;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Identifier;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.ListItem;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceComposite;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Publication;
import org.homelinux.elabor.scriptorium.ecomponents.Quadratus;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.ReadingReference;
import org.homelinux.elabor.scriptorium.ecomponents.Receiver;
import org.homelinux.elabor.scriptorium.ecomponents.ReceiverPlace;
import org.homelinux.elabor.scriptorium.ecomponents.Rectangulus;
import org.homelinux.elabor.scriptorium.ecomponents.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.References;
import org.homelinux.elabor.scriptorium.ecomponents.Release;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Title;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessId;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessesIds;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NullEditionVisitor;
import org.homelinux.elabor.scriptorium.exports.HeaderInfo;
import org.homelinux.elabor.scriptorium.exports.IndexInfo;
import org.homelinux.elabor.scriptorium.exports.TextPartType;
import org.homelinux.elabor.scriptorium.gui.DocumentTypeRenderer;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;

public class MTeXEditionVisitor
extends NullEditionVisitor {
    private static final String SCONOSCIUTO = "sconosciuto";
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(1, Locale.ITALIAN);
    private static final String LABEL_PREFIX = "lab";
    private PrintWriter writer;
    private Ontology namesOntology;
    private Ontology placesOntology;
    private Ontology variantsOntology;
    private Ontology worksOntology;
    private Ontology partsOntology;
    private Ontology publicationsOntology;
    private MessageCatalog variantsOntologyCatalog;
    private String variantItemReadingValue;
    private TextPartType pendingTextPart;
    private boolean annotations;
    private List<HeaderInfo> headers;
    private List<IndexInfo> names;
    private List<IndexInfo> places;
    private List<IndexInfo> works;
    private int indexCount;
    private int headerCount;
    private int imageCount;
    private File imageFolder;
    private DocumentTypeRenderer autogrRenderer;
    private Folium pendingFolium;
    private String letterLabel;
    private int nPar;
    private HeaderInfo headerInfo;
    private final EditionManager editionManager = EditionManager.getInstance();

    public MTeXEditionVisitor() {
        this.partsOntology = this.editionManager.getTextPartsOntology();
        this.namesOntology = this.editionManager.getNamesOntology();
        this.placesOntology = this.editionManager.getPlacesOntology();
        this.worksOntology = this.editionManager.getWorksOntology();
        this.publicationsOntology = this.editionManager.getPublicationsOntology();
        this.variantsOntology = this.editionManager.getVariantsOntology();
        this.variantsOntologyCatalog = new MessageCatalog();
        Class<?> thisClass = this.getClass();
        String className = thisClass.getName();
        Locale defaultLocale = Locale.getDefault();
        this.variantsOntologyCatalog.loadCatalog(className, defaultLocale);
        this.annotations = false;
        this.headers = new ArrayList<HeaderInfo>();
        this.names = new ArrayList<IndexInfo>();
        this.places = new ArrayList<IndexInfo>();
        this.works = new ArrayList<IndexInfo>();
        this.indexCount = 0;
        this.headerCount = 0;
        this.autogrRenderer = new DocumentTypeRenderer();
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void visit(AbstractShape<?> shape) {
    }

    @Override
    public void visit(Annotation annotation) {
        String value = annotation.getValue();
        this.writer.print("\\Adnotatio{" + value + "}");
        this.annotations = true;
    }

    @Override
    public void visit(Author author) {
    }

    @Override
    public void visit(AuthorPlace authorPlace) {
    }

    @Override
    public void visit(ReceiverPlace receiverPlace) {
    }

    @Override
    public void visit(BackgroundImage image) {
    }

    @Override
    public void visit(Citation citation) {
        this.writer.print("\\Cit{");
        Content text = citation.getContent();
        String id = citation.getId();
        this.writer.print("{" + text + "}");
        this.writer.print("{" + id + "}");
        this.writer.print("}");
    }

    @Override
    public void visit(Comment comment) {
    }

    @Override
    public void visit(Conspectus conspectus) {
    }

    @Override
    public void visit(Content content) {
        this.defaultVisit(content);
    }

    @Override
    public void visit(Crux crux) {
        this.writer.print("\\CRUX{");
        this.defaultVisit(crux);
        this.writer.print("}");
    }

    @Override
    public void visit(DateToken date_token) {
        this.writer.print("\\Date{{");
        this.defaultVisit(date_token);
        this.writer.print("}}");
    }

    @Override
    public void visit(Description description) {
        this.writer.print("{");
        WitnessesIds ids = description.getWitnessesIds();
        if (ids == null) {
            this.writer.print("*");
        } else {
            ids.accept(this);
        }
        List<DescriptionItem> items = description.getItems();
        if (items.size() > 0) {
            this.writer.print(":");
            for (DescriptionItem item : items) {
                item.accept(this);
            }
        }
        this.writer.print(":" + this.variantItemReadingValue);
        this.writer.println("}");
    }

    @Override
    public void visit(DescriptionItem descriptionItem) {
        this.defaultVisit(descriptionItem);
    }

    @Override
    public void visit(Drawing drawing) {
    }

    @Override
    public void visit(Edition edition) {
        this.imageFolder = EditionManager.getImageDefaultFolder(edition);
        this.imageCount = 0;
        this.writer.println("\\inizioepistola");
        this.defaultVisit(edition);
        this.closeTextPart();
        this.writer.println("\\fineepistola");
    }

    @Override
    public void visit(EditionDate editionDate) {
    }

    @Override
    public void visit(Enunciatio enunciatio) {
        this.writer.println("\\begin{Enunciatio}");
        this.defaultVisit(enunciatio);
        this.writer.print("\\end{Enunciatio}");
    }

    @Override
    public void visit(Expunctio expunctio) {
        this.writer.print("\\EXPU{");
        this.defaultVisit(expunctio);
        this.writer.print("}");
    }

    @Override
    public void visit(Folium folium) {
        this.queue(folium);
        this.handleFolium();
    }

    private void queue(Folium folium) {
        this.pendingFolium = folium;
    }

    private void handleFolium() {
        if (this.pendingFolium != null) {
            String page = this.pendingFolium.getPage();
            this.writer.print("\\Folium{");
            this.writer.print(String.valueOf(page) + "} ");
            this.pendingFolium = null;
        }
    }

    @Override
    public void visit(Formula formula) {
        this.writer.print("$");
        this.defaultVisit(formula);
        this.writer.print("$");
    }

    private static String getDateValue(Date date, String dateComment) {
        String dateValue = "";
        if (!dateComment.equals("")) {
            dateValue = dateComment;
        } else if (date != null) {
            dateValue = DATE_FORMAT.format(date);
        }
        return dateValue;
    }

    @Override
    public void visit(GlyphGroup group) {
    }

    @Override
    public void visit(Header header) {
        this.nPar = 0;
        this.writer.println("\\par");
        this.writer.println("\\vspace{1cm}");
        this.writer.println("\\begin{center}");
        ++this.headerCount;
        this.writer.println("\\textbf{" + this.headerCount + "}\\par");
        OntologyReferenceInterface author = header.getAuthor();
        String authName = this.editionManager.getOntologyValue(this.namesOntology, author);
        if (header.isAuthorIncerto()) {
            authName = "\\Bibrif{" + authName + "}";
        }
        this.writer.print("\\textbf{");
        this.writer.print(authName);
        this.writer.print(" a ");
        OntologyReferenceInterface receiver = header.getReceiver();
        String recName = this.editionManager.getOntologyValue(this.namesOntology, receiver);
        if (header.isReceiverIncerto()) {
            recName = "\\Bibrif{" + recName + "}";
        }
        this.writer.print(recName);
        this.writer.println("}\\par");
        OntologyReferenceInterface authorPlace = header.getAuthorPlace();
        String authorPlaceName = this.editionManager.getOntologyValue(this.placesOntology, authorPlace);
        this.writer.print("\\textbf{");
        if (!authorPlaceName.equals(SCONOSCIUTO)) {
            this.writer.print(authorPlaceName);
            this.writer.print(", ");
        }
        Date date = header.getDate();
        String dateComment = header.getDateComment();
        String dateValue = MTeXEditionVisitor.getDateValue(date, dateComment);
        this.writer.print(dateValue);
        this.writer.println("}\\par");
        String id = header.getIdentifier();
        DocumentType documentType = header.getDocumentType();
        String autogr = this.autogrRenderer.getMessage(documentType);
        this.writer.print(String.valueOf(id.trim()) + "; " + autogr);
        this.letterLabel = header.getTitle();
        this.writer.print("\\letterlabel{" + this.letterLabel + "}{" + this.headerCount + "}");
        OntologyReferenceInterface publi = header.getPublication();
        String publication = this.editionManager.getOntologyValue(this.publicationsOntology, publi);
        if (!publication.isEmpty() && !publication.equals(SCONOSCIUTO)) {
            publication = publication.replaceAll("\\[", "\\\\Bibrif{");
            publication = publication.replaceAll("\\]", "}");
            this.writer.print("\\footnote{" + publication + "}");
        }
        this.writer.println();
        this.writer.println("\\end{center}");
        this.writer.println("\\vspace{5mm}");
        this.writer.println("\\par");
        this.headerInfo = new HeaderInfo(this.headerCount, id, date, dateComment, authName, recName, this.letterLabel, publication, documentType);
        this.headers.add(this.headerInfo);
    }

    @Override
    public void visit(TextPart text) {
        List<OntologyReference> oRefs = text.getOntologyReferences();
        if (oRefs.isEmpty()) {
            this.closeTextPart();
        } else {
            TextPartType type;
            OntologyReference oRef = oRefs.get(0);
            OntologyClass ontClass = this.partsOntology.getOntologyClass(oRef);
            try {
                String name = ontClass.getComment();
                type = TextPartType.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                type = TextPartType.DEFAULT;
            }
            if (type.isCollapse() && type.equals((Object)this.pendingTextPart)) {
                this.writer.println("\\par");
            } else {
                this.closeTextPart();
                type.open(this.writer);
            }
            ++this.nPar;
            if (this.nPar < 3) {
                if (this.nPar == 2) {
                    this.writer.println("\\vspace{\\medskipamount}");
                }
                this.writer.println("\\noindent");
            }
            this.pendingTextPart = type;
        }
    }

    private void closeTextPart() {
        if (this.pendingTextPart != null) {
            this.pendingTextPart.close(this.writer);
            this.pendingTextPart = null;
        }
    }

    @Override
    public void visit(Identifier identifier) {
    }

    @Override
    public void visit(Image image) {
        ++this.imageCount;
        URI uri = image.getUri();
        File file = FileSystemTools.getFileFromUri(this.imageFolder, uri);
        String value = file.getAbsolutePath();
        int letterNumber = this.headerInfo.getLetterNumber();
        String description = image.getCaption();
        this.writer.print("\\Figura");
        String numberString = String.valueOf(this.imageCount);
        this.writer.print("[Figura " + letterNumber + "." + numberString);
        if (!description.isEmpty()) {
            this.writer.print(" - " + description);
        }
        this.writer.print("]");
        this.writer.print("{" + value + "}");
    }

    @Override
    public void visit(Integratio integratio) {
        String value = integratio.getValue();
        this.writer.print("\\INTE{" + value + "}");
    }

    @Override
    public void visit(ListItem listItem) {
    }

    @Override
    public void visit(MathConcept mathConcept) {
        Content content = mathConcept.getContent();
        content.accept(this);
    }

    @Override
    public void visit(Name name) {
        Content content = name.getContent();
        String comment = name.getComment();
        if (comment.isEmpty()) {
            content.accept(this);
        } else {
            this.writer.print("\\Nome{{");
            content.accept(this);
            this.writer.print("}{" + comment + "}}");
        }
        List<OntologyReference> references = name.getOntologyReferences();
        boolean incerto = name.isIncerto();
        this.handleInfos(this.names, this.namesOntology, references, incerto);
    }

    @Override
    public void visit(OntologyReference reference) {
        OntologyClass ontologyClass = this.variantsOntology.getOntologyClass(reference);
        String comment = ontologyClass.getComment();
        try {
            String maurotex = this.variantsOntologyCatalog.getString(comment);
            this.writer.print(maurotex);
        }
        catch (MissingResourceException e) {
            this.writer.print("\\DES{" + comment + "}");
        }
        String argument = reference.getArgument();
        if (!argument.isEmpty()) {
            this.writer.print("\\DES{" + argument + "}");
        }
    }

    @Override
    public void visit(Place place) {
        Content content = place.getContent();
        this.handleOntologyToken(place, "Luogo", null, content, this.placesOntology, this.places);
    }

    @Override
    public void visit(Publication publication) {
    }

    @Override
    public void visit(Quadratus quadratus) {
    }

    @Override
    public void visit(Reading reading) {
        String value = reading.getValue();
        this.writer.print("\\LEC{" + value + "}");
    }

    @Override
    public void visit(ReadingReference reference) {
        this.writer.print("\\LEC{" + this.variantItemReadingValue + "}");
    }

    @Override
    public void visit(Receiver receiver) {
    }

    @Override
    public void visit(Rectangulus rectangulus) {
    }

    @Override
    public void visit(Reference reference) {
    }

    @Override
    public void visit(References references) {
    }

    @Override
    public void visit(Release release) {
    }

    @Override
    public void visit(ScriptoriumPoint point) {
    }

    @Override
    public void visit(ScriptoriumShape shape) {
    }

    @Override
    public void visit(ScriptoriumStyle scriptoriumStyle) {
    }

    @Override
    public void visit(StyleSetReference styleSet) {
    }

    @Override
    public void visit(Text text) {
        String value = text.getValue();
        this.writer.print(value);
    }

    @Override
    public void visit(Title title) {
    }

    @Override
    public void visit(Tongue tongue) {
        this.writer.print("{\\it ");
        Content content = tongue.getContent();
        content.accept(this);
        this.writer.print("}");
    }

    @Override
    public void visit(Transform transform) {
    }

    @Override
    public void visit(Unit unit) {
        String label = unit.getLabel();
        String note = unit.getNote();
        this.writer.print("\\Unit");
        if (!label.isEmpty()) {
            this.writer.print("[" + this.letterLabel + "_" + label + "]");
        }
        if (!note.isEmpty()) {
            this.writer.print("\\marginpar{\\footnotesize{" + note + "}}");
        }
        this.writer.print("~");
    }

    @Override
    public void visit(Variant variant) {
        this.writer.print("\\VV{");
        this.defaultVisit(variant);
        this.writer.print("}");
    }

    @Override
    public void visit(VariantItem variantItem) {
        Reading reading = variantItem.getReading();
        this.variantItemReadingValue = reading.getValue();
        List<Description> descriptions = variantItem.getDescriptions();
        if (descriptions.size() == 0) {
            this.writer.println("{*:" + this.variantItemReadingValue + "}");
        } else {
            for (Description description : descriptions) {
                description.accept(this);
            }
        }
    }

    @Override
    public void visit(Witness witness) {
    }

    @Override
    public void visit(WitnessesIds ids) {
        List<WitnessId> idsList = ids.getWitnessIds();
        Iterator<WitnessId> iterator = idsList.iterator();
        if (iterator.hasNext()) {
            WitnessId id = iterator.next();
            id.accept(this);
            while (iterator.hasNext()) {
                this.writer.print("/");
                id = iterator.next();
                id.accept(this);
            }
        } else {
            this.writer.print("*");
        }
    }

    @Override
    public void visit(WitnessId witnessId) {
        String id = witnessId.getId();
        this.writer.print(id);
    }

    @Override
    public void visit(Work work) {
        Content content = work.getContent();
        String style = work.isItalic() ? "textit" : null;
        this.handleOntologyToken(work, "Opera", style, content, this.worksOntology, this.works);
    }

    private void defaultVisit(EditionComponent<?> component) {
        List<EditionComponent<?>> children = component.getChildren();
        Iterator<EditionComponent<?>> iterator = children.iterator();
        if (iterator.hasNext()) {
            EditionComponent<?> previous = iterator.next();
            while (iterator.hasNext()) {
                EditionComponent<?> current = iterator.next();
                String prevName = previous.getElementName();
                String currName = current.getElementName();
                if (prevName.equals("folium") && currName.equals("part")) {
                    this.closeTextPart();
                }
                previous.accept(this);
                previous = current;
            }
            previous.accept(this);
        }
    }

    private void handleOntologyToken(OntologyReferenceComposite<?> composite, String token, String style, Content content, Ontology ontology, List<IndexInfo> infos) {
        boolean styleNotNull;
        this.writer.print("\\" + token + "{{");
        boolean bl = styleNotNull = style != null;
        if (styleNotNull) {
            this.writer.print("\\" + style + "{");
        }
        content.accept(this);
        if (styleNotNull) {
            this.writer.print("}");
        }
        this.writer.print("}{");
        List<OntologyReference> references = composite.getOntologyReferences();
        Iterator<OntologyReference> iterator = references.iterator();
        if (iterator.hasNext()) {
            while (true) {
                OntologyReference reference = iterator.next();
                String value = this.editionManager.getOntologyValue(ontology, reference);
                this.writer.print(value);
                if (!iterator.hasNext()) break;
                this.writer.print(", ");
            }
        }
        this.writer.print("}}");
        this.handleInfos(infos, ontology, references, false);
    }

    private void handleInfos(List<IndexInfo> infos, Ontology ontology, List<OntologyReference> references, boolean incerto) {
        if (infos != null) {
            String label = this.getNextIndexLabel();
            this.writer.print("\\label{" + label + "}");
            for (OntologyReference reference : references) {
                OntologyClass ontologyClass = ontology.getOntologyClass(reference);
                if (ontologyClass == null) continue;
                String entry = ontologyClass.getOrderString();
                int letterNumber = this.headerInfo.getLetterNumber();
                IndexInfo info = new IndexInfo(label, entry, letterNumber, incerto);
                infos.add(info);
            }
        }
    }

    private String getNextIndexLabel() {
        ++this.indexCount;
        return LABEL_PREFIX + this.indexCount;
    }

    public boolean hasAnnotations() {
        return this.annotations;
    }

    public List<HeaderInfo> getHeaders() {
        return this.headers;
    }

    public List<IndexInfo> getNames() {
        return this.names;
    }

    public List<IndexInfo> getPlaces() {
        return this.places;
    }

    public List<IndexInfo> getWorks() {
        return this.works;
    }

    @Override
    public void visit(ComputeAction computeAction) {
    }

    @Override
    public void visit(StraightLineAction straightLineAction) {
    }

    @Override
    public void visit(StraightLineDirectionAction straightLineDirectionAction) {
    }
}

